% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fund_search.R
\name{fund_search}
\alias{fund_search}
\alias{fund_fast_search}
\title{SEC Mutual Fund Search}
\usage{
fund_search(term)

fund_fast_search(identifier)
}
\arguments{
\item{term}{Search term to search for in a fund name}

\item{identifier}{A Series, Class/Contract ID, Ticker Symbol or CIK}
}
\value{
A dataframe of funds found including the following columns -
  \itemize{
    \item class_id
    \item class_filings_href
    \item class_name
    \item class_ticker
    \item series_id
    \item series_filings_href
    \item series_name
    \item series_funds_href
    \item cik
    \item cik_name
    \item cik_filings_href
    \item cik_funds_href
  }
}
\description{
Provides access to the results of the SEC's Mutual fund search tool
available
\href{https://www.sec.gov/edgar/searchedgar/mutualsearch.html}{here}
}
\details{
NOTE: This is really a specific version of the Variable Insurance search
tool.
}
\section{Functions}{
\itemize{
\item \code{fund_fast_search}: Performs a 'Fast Search' based on a fund identifier
}}

\examples{
\donttest{
try(fund_search("precious metals"))
try(fund_fast_search("VMFVX"))
}
}
