% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activationsEvents.R
\name{activationsEvents}
\alias{activationsEvents}
\title{Calculate the activations for each learning event.}
\usage{
activationsEvents(
  wmlist,
  data,
  split = "_",
  fun = NULL,
  return.list = FALSE,
  init.value = 0,
  normalize = FALSE
)
}
\arguments{
\item{wmlist}{A list with weightmatrices, generated by 
\code{\link{RWlearning}} or \code{\link{updateWeights}}, 
or a single weightmatrix (matrix).}

\item{data}{Data frame with columns \code{Cues} and \code{Outcomes}. 
Number of rows should be the same as the number of weightmatrices 
in \code{wmlist}.}

\item{split}{String, separator between cues and/or outcomes.}

\item{fun}{Function to apply to the activations for events with 
multiple outcomes. By default (\code{fun=NULL}) the activation values 
for each outcome are returned. If there are learning events with 
multiple outcomes, the argument \code{return.list} will be 
automatically set to TRUE.}

\item{return.list}{Logical: whether or not the activation values are 
returned as list or as vector. Defaults to the value FALSE, 
returning a vector of activation values. 
But this also depends on the argument \code{fun} 
(see more info above).}

\item{init.value}{Value of activations for non-existing connections. 
Typically set to 0.}

\item{normalize}{Logical: whether or not the activation is normalized by 
dividing the total activation by the number of cues. Default is FALSE. If 
set to TRUE, the activation reflects the average activation per cue.}
}
\value{
Vector or list of activation values (see \code{return.list} 
and \code{fun} for the specific conditions, and the examples below).
}
\description{
Calculate the activations for each learning event. 
The values are returned as data frame or as a list of data frames.
}
\examples{
# load example data:
data(dat)

# add obligatory columns Cues, Outcomes, and Frequency:
dat$Cues <- paste("BG", dat$Shape, dat$Color, sep="_")
dat$Outcomes <- dat$Category
dat$Frequency <- dat$Frequency1
head(dat)

# now use createTrainingData to sample from the specified frequencies: 
train <- createTrainingData(dat)
head(train)

# this training data can actually be used train network:
wm <- RWlearning(train)

# Now we calculate the activations for each event:
train$Activation <- activationsEvents(wm, train)

# With multiple outcomes per event, it is better not 
# to directly assign to a new column, as a list will 
# return. See the example below:
dat$Outcomes <- paste(dat$Shape, dat$Color, sep="_")
dat$Cues <- paste("BG", dat$Category, sep="_")
dat$Frequency <- dat$Frequency1
head(dat)
train <- createTrainingData(dat)
wm <- RWlearning(train)
# This code will elicit a warning message:
\dontrun{
    act <- activationsEvents(wm, train)
}
# this code will not elicit a warning:
act <- activationsEvents(wm, train, return.list=TRUE)
head(act)
# to assign one single activation value to each event,
# we could instead apply a function, for example, by
# taking the max activation per event:
train$maxAct <- activationsEvents(wm, train, fun="max")

}
\seealso{
\code{\link{getWeightsByCue}},
\code{\link{getWeightsByOutcome}}

Other functions for calculating activations: 
\code{\link{activationsCueSet}()},
\code{\link{activationsMatrix}()},
\code{\link{activationsOutcomes}()},
\code{\link{getActivations}()}
}
\author{
Jacolien van Rij
}
\concept{functions for calculating activations}
