% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWM.R
\name{getWM}
\alias{getWM}
\title{Retrieve all cues from a vector of text strings.}
\usage{
getWM(wmlist, event = NULL)
}
\arguments{
\item{wmlist}{A list with weightmatrices for each learning event, 
generated by \code{\link{RWlearning}}.}

\item{event}{Numeric: for which event to return the weight matrix. 
Defaults to NULL, which wil return the last weight matrix.}
}
\value{
A matrix with connection weights between cues (rows) and outcomes.
}
\description{
Retrieve all cues from a vector of text strings.
}
\examples{
# load example data:
data(dat)

# add obligatory columns Cues, Outcomes, and Frequency:
dat$Cues <- paste("BG", dat$Shape, dat$Color, sep="_")
dat$Outcomes <- dat$Category
dat$Frequency <- dat$Frequency1
head(dat)
dim(dat)

# now use createTrainingData to sample from the specified frequencies: 
train <- createTrainingData(dat)

# this training data can actually be used train network:
wm <- RWlearning(train)

# final weight matrix:
getWM(wm)
# ... which is the same as:
wm[[length(wm)]]
# 25th learning event:
getWM(wm, event=25)
# ... which is the same as:
wm[[25]]

}
\seealso{
\code{\link{RWlearning}}, \code{\link{getWeightsByCue}}, 
\code{\link{getWeightsByOutcome}}
}
\author{
Jacolien van Rij
}
