% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KM_package.R
\name{make.audit.from.Z}
\alias{make.audit.from.Z}
\alias{make.audit}
\title{Make a fake audit given specified error for simulations}
\usage{
make.audit.from.Z(Z, N = 400, ...)

make.audit(
  Z = NULL,
  method = c("tweak", "opt.bad", "opt.bad.WPM", "opt.bad.packed", "opt.bad.packed.WPM",
    "ok", "no error"),
  p_d = 0.2,
  swing = 20,
  max.taint = 1,
  print.race = FALSE,
  ...
)
}
\arguments{
\item{Z}{elec.data object.  For make.audit.from.Z, this is the large
election, holding precincts with size, votes, etc., that get sampled to make
an election of a requested number of batches.}

\item{N}{The desired size of the new election.}

\item{\dots}{other arguments to the method functions}

\item{method}{the method of error generation.  if "tweak" (the default),
then add random amounts of swing to some precincts, and call that the
"truth".  The other methods generate the truth according to various metrics.}

\item{p_d}{percent chance of error in precinct (for ok method)}

\item{swing}{vote swing if batch has error (for ok method)}

\item{max.taint}{maximum taint allowed in batch}

\item{print.race}{print info on race to command line?}
}
\value{
Data frame with precinct information for the race.  NOTE- The reported vote
totals are just that, reported.
}
\description{
Functions that make fake audits given a specified error mechanism and a
elec.data object holding reported outcomes.
}
\details{
make.audit is to make the election results that can be sampled from with the
simulator.  This method generates the true taint and sampling weights of all
precincts in the race.  The taint is in column 'taint', sampling weights in
'e.max'

make.audit.from.Z Given the structure of some large election, make a small
election by sampling batches (with replacement) from the full list.  This
first samples N precincts (and gets the totals from them) and then builds
the 'truth' as normal using the make.audit() method.  Note different calls
to this will produce different margins based on precincts selected.

WARNING: It is concievable that the winner will flip due to the sampling, if
the sample has too many batches for the loser.
}
\seealso{
\link{truth.looker}
}
\author{
Miratrix
}
