% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elec-package.R
\docType{data}
\name{santa.cruz}
\alias{santa.cruz}
\title{Santa Cruz Election Data}
\format{
A data frame with 152 observations on the following 5 variables.
\describe{ \item{PID}{Precinct IDs (unique) for all precincts
involved in race} \item{r}{Total number of registered voters in the
precinct.} \item{tot.votes}{Total number of ballots cast in the
precinct.} \item{leopold}{Total number of ballots marked for John
Leopold.} \item{danner}{Total number of ballots marked for Betty
Danner.} }
}
\source{
Santa Cruz County, CA, Clerk Gail Pellerin, and their staff.
}
\description{
\code{santa.cruz} and \code{santa.cruz.audit} hold data from a Santa Cruz
County, CA, contest held in November, 2008, for County Supervisor in the 1st
District.  The competitive candidates were John Leopold and Betty Danner.
According to the semi-official results provided to us by the Santa Cruz
County Clerk's office, Leopold won with votes on 45\% of the 26,655 ballots.
Danner received the votes on 37\% of the ballots.  The remaining ballots
were undervoted, overvoted, or had votes for minor candidates.

\code{santa.cruz} holds the semi-official results for the race.
\code{santa.cruz.audit} holds the audit totals for the random sample of
precincts selected for the audit.  Note the \code{santa.cruz.audit} vote
counts are larger for some precincts due the missing provisional ballot
counts in the semi-official results.
}
\examples{

data(santa.cruz)
elec.data( santa.cruz, C.names=c("danner","leopold") )

}
\seealso{
\link{santa.cruz.audit}
}
\keyword{datasets}
