#' Simulated Regression Data
#'
#' @description A data set with simulated data from mixture regression models.
#' @name simreg
#' @docType data
#' @keywords data
#' @format A data frame with 1000 rows and 5 variables:
#' \describe{
#'   \item{yp}{A dependent variable generated from a mixture 
#'   of a poisson regression with x}
#'   \item{yn}{A dependent variable generated from a mixture 
#'   of a linear regression with x}
#'   \item{yc}{A dependent variable generated from a mixture 
#'   of a linear regression with x and a concomitant variable of z}
#'   \item{x}{An independent variable}
#'   \item{z}{A concomitant variable}
#' }
#' @source <https://www.github.com/wudongjie/em>
"simreg"

#' Simulated Data from a logistic regression
#'
#' @description A data set with simulated data from 
#' a mixture of a logistic regression.
#' @name simbinom
#' @docType data
#' @keywords data
#' @format A data frame with 10000 rows and 2 variables:
#' \describe{
#'   \item{y}{A dependent variable generated from a mixture of 
#'   a logistic regression with x}
#'   \item{x}{An independent variable}
#' }
#' @source <https://www.github.com/wudongjie/em>
"simbinom"

#' Simulated Data from a conditional logistic regression
#'
#' @description A data set with simulated data from a mixture of a conditional 
#' logistic regression.
#' @name simclogit
#' @docType data
#' @keywords data
#' @format A data frame with 10000 rows and 4 variables:
#' \describe{
#'   \item{x2}{A dummy variable showing whether x is equal to level 2}
#'   \item{x3}{A dummy variable showing whether x is equal to level 3}
#'   \item{a2}{Whether the alternative choice 2 is chosen}
#'   \item{a2_x2}{Interaction between a2 and x2}
#'   \item{a2_x3}{Interaction between a2 and x3}
#'   \item{a3}{Whether the alternative choice 3 is chosen}
#'   \item{a3_x2}{Interaction between a3 and x2}
#'   \item{a3_x3}{Interaction between a3 and x3}
#'   \item{chosen1}{Whether the observation-alternative combination is 
#'   chosen (Generated by a one-class regression).}
#'   \item{chosen2}{Whether the observation-alternative combination is 
#'   chosen (Generated by a two-class mixed regression).}
#'   \item{fid}{Family ID}
#'   \item{id}{Individual ID}
#'   \item{z}{Other variables}
#' }
#' @source <https://www.github.com/wudongjie/em>
"simclogit"
