% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epichains.R
\name{aggregate.epichains}
\alias{aggregate.epichains}
\title{Aggregate cases in \verb{<epichains>} objects by "generation" or "time", if
present}
\usage{
\method{aggregate}{epichains}(x, by = c("time", "generation"), ...)
}
\arguments{
\item{x}{An \verb{<epichains>} object.}

\item{by}{The variable to aggregate by; A character string with options
"time" and "generation".}

\item{...}{Not used.}
}
\value{
A \verb{<data.frame>} object of cases by \code{by}.
}
\description{
This function provides a quick way to create a time series of cases over
generation or time (if \code{generation_time} was specified) from simulated
\verb{<epichains>} objects.
}
\examples{
set.seed(32)
chains <- simulate_chains(
  n_chains = 10,
  statistic = "size",
  offspring_dist = rpois,
  stat_threshold = 10,
  generation_time = function(n) rep(3, n),
  lambda = 2
)
chains

# Aggregate cases per time
cases_per_time <- aggregate(chains, by = "time")
head(cases_per_time)

# Aggregate cases per generation
cases_per_gen <- aggregate(chains, by = "generation")
head(cases_per_gen)
}
\author{
James M. Azam
}
