% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_coordinates.R, R/get_coordinates.R
\name{add_coordinates}
\alias{add_coordinates}
\alias{get_coordinates}
\alias{get_coordinates.epiflows}
\title{Add/Retrieve location coordinates}
\usage{
add_coordinates(
  x,
  coordinates = c("lon", "lat"),
  loc_column = "id",
  overwrite = FALSE
)

get_coordinates(x, ...)

\method{get_coordinates}{epiflows}(x, location = NULL, ...)
}
\arguments{
\item{x}{An \code{epiflows} object.}

\item{coordinates}{Either names of the appended columns with longitudes
and latitudes, respectively (default: "lon" and "lat") or a data frame with longitude and latitude columns.}

\item{loc_column}{Name of the column where location names are stored
(default: "country").}

\item{overwrite}{If TRUE, retrieves all geocodes, even those already
retrieved. If FALSE (default), overwrites only NAs.}

\item{...}{unused}

\item{location}{a character specifying a single location to return as a vector of
coordinates. You cannot specify multiple locations with this parameter.
Defaults to `NULL`, indicating all locations.}
}
\value{
An updated \code{epiflows} object.
}
\description{
Adds/Retrieves longitude/latitude values to location data within an epiflows object.
Coordinates are added to object's locations slot as \code{lon} and \code{lat}
columns.
}
\examples{

# Setting up the data
data("Brazil_epiflows")
data("YF_coordinates")
get_coordinates(Brazil_epiflows) # no coordinates yet
ef <- add_coordinates(Brazil_epiflows, YF_coordinates[-1])
get_coordinates(ef)
get_coordinates(ef, location = "Espirito Santo") # coordinates for Espirito Santo
if (interactive()) {
  # You can use google maps' geocode functionality if you have a decent 
  # internet connection
  # NOTE: you may need to authenticate with Google Maps API beforehand
  # using ggmap::register_google()
  ef2 <- add_coordinates(Brazil_epiflows, loc_column = "id")
  ef2
}

}
\seealso{
\code{\link[=map_epiflows]{map_epiflows()}}; \code{\link[=plot.epiflows]{plot.epiflows()}}; \code{\link[=get_locations]{get_locations()}}; \code{\link[=get_vars]{get_vars()}};
\code{\link[=global_vars]{global_vars()}}
}
\author{
Pawel Piatkowski, Salla Toikkanen, Zhian Kamvar
}
