% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epoxy_use.R
\name{epoxy_use}
\alias{epoxy_use}
\alias{epoxy_use_chunk}
\alias{epoxy_use_file}
\title{Reuse a Template Chunk}
\usage{
epoxy_use_chunk(.data = NULL, label, ...)

epoxy_use_file(.data = NULL, file, ...)
}
\arguments{
\item{.data}{A data set}

\item{label}{The chunk label, i.e. the human-readable name, of the chunk
containing the template string. This chunk should be an \code{epoxy},
\code{epoxy_html} or other epoxy-provided chunk type and it must have a label.
\code{epoxy_use_chunk()} will apply the options from this chunk to the template,
giving preference to arguments in \code{epoxy_use_chunk()} or the chunk options
where it is called. See the "Template Options" section for more details.}

\item{...}{
  Arguments passed on to \code{\link[=epoxy]{epoxy}}
  \describe{
    \item{\code{.transformer}}{A transformer function or transformer chain created with
\code{\link[=epoxy_transform]{epoxy_transform()}}. Alternatively, a character vector of epoxy transformer
names, e.g. \code{c("bold", "collapse")} or a list of epoxy transformers, e.g.
\code{list(epoxy_transform_bold(), epoxy_transform_collapse())}.

In \pkg{epoxy}, you'll most likely want to use the defaults or consult
\code{\link[=epoxy_transform]{epoxy_transform()}} for more information. See also \code{\link[glue:glue]{glue::glue()}} for more
information on transformers.}
    \item{\code{.style}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use \code{.transformer}
instead.}
    \item{\code{.open}}{[\code{character(1)}: \sQuote{\\\{}]\cr The opening delimiter around
the template variable or expression. Doubling the full delimiter escapes
it.}
    \item{\code{.close}}{[\code{character(1)}: \sQuote{\\\}}]\cr The closing delimiter
around the template variable or expression. Doubling the full delimiter
escapes it.}
    \item{\code{.collapse}}{A character string used to collapse a vector result into a
single value. If \code{NULL} (the default), the result is not collapsed.}
    \item{\code{.sep}}{[\code{character(1)}: \sQuote{""}]\cr Separator used to separate elements.}
    \item{\code{.envir}}{[\code{environment}: \code{parent.frame()}]\cr Environment to evaluate each expression in. Expressions are
evaluated from left to right. If \code{.x} is an environment, the expressions are
evaluated in that environment and \code{.envir} is ignored. If \code{NULL} is passed, it is equivalent to \code{\link[=emptyenv]{emptyenv()}}.}
    \item{\code{.na}}{[\code{character(1)}: \sQuote{NA}]\cr Value to replace \code{NA} values
with. If \code{NULL} missing values are propagated, that is an \code{NA} result will
cause \code{NA} output. Otherwise the value is replaced by the value of \code{.na}.}
    \item{\code{.null}}{[\code{character(1)}: \sQuote{character()}]\cr Value to replace
NULL values with. If \code{character()} whole output is \code{character()}. If
\code{NULL} all NULL values are dropped (as in \code{paste0()}). Otherwise the
value is replaced by the value of \code{.null}.}
    \item{\code{.comment}}{[\code{character(1)}: \sQuote{#}]\cr Value to use as the comment
character.}
    \item{\code{.literal}}{[\code{boolean(1)}: \sQuote{FALSE}]\cr Whether to treat single or
double quotes, backticks, and comments as regular characters (vs. as
syntactic elements), when parsing the expression string. Setting \code{.literal = TRUE} probably only makes sense in combination with a custom
\code{.transformer}, as is the case with \code{glue_col()}. Regard this argument
(especially, its name) as experimental.}
    \item{\code{.trim}}{[\code{logical(1)}: \sQuote{TRUE}]\cr Whether to trim the input
template with \code{\link[glue:trim]{trim()}} or not.}
  }}

\item{file}{The template file, i.e. a plain text file, containing the
template. An \code{.md} or \code{.txt} file extension is recommended. In addition to
the template, the file may also contain YAML front matter containing
options that are used when rendering the template via \code{\link[=epoxy]{epoxy()}}.}
}
\value{
A character string of the rendered template based on the \code{label}
chunk. The results are marked as \code{"asis"} output so that they are treated
as regular text rather than being displayed as code results.
}
\description{
Reuse a template from another chunk or file. By calling \code{epoxy_use_chunk()}
in an R chunk or inline R expression, you can reuse a template defined in
another chunk in your document.

Alternatively, you can store the template in a separate file and use
\code{epoxy_use_file()} to reuse it. When stored in a file, the template file can
contain YAML front matter (following the \href{https://pandoc.org/MANUAL.html#extension-yaml_metadata_block}{same rules as pandoc documents})
with options that should be applied when calling an epoxy function. The
specific function called by \code{epoxy_use_file()} can be set via the \code{engine}
option in the YAML front matter; the default is \code{\link[=epoxy]{epoxy()}}.
}
\section{Use in R Markdown or Quarto}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{epoxy movie-release\}
\{.emph title\} was released in \{year\}.
```

```\{r\}
# Re-using the template we defined above
epoxy_use_chunk(bechdel[1, ], "movie-release")
```

```\{r\}
# Using in a dplyr pipeline
bechdel |>
  dplyr::filter(year == 1989) |>
  epoxy_use_chunk("movie-release")
```
}\if{html}{\out{</div>}}

Or you can even use it inline:

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{It's hard to believe that
`r epoxy_use_chunk(bechdel[2, ], "movie-release")`.
}\if{html}{\out{</div>}}

It's hard to believe that
\emph{Back to the Future Part II} was released in 1989.

The same template could also be stored in a file, e.g. \code{movie-release.md}:

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{---
engine: epoxy
---

\{.emph title\} was released in \{year\}.
}\if{html}{\out{</div>}}

The YAML front matter is used in template files to set options for the
template. You can use the \code{engine} option to choose the epoxy function to be
applied to the template, e.g. \code{engine: epoxy_html} or \code{engine: epoxy_latex}.
By default, \code{engine: epoxy} is assumed unless otherwise specified.
}

\section{Template Options}{


When rendering a template, \code{epoxy_use_chunk()} and \code{epoxy_use_file()} will
inherit the options set in a number of different ways. The final template
options are determined in the following order, ranked by importance. Options
set in a higher-ranked location will override options set in a lower-ranked
location.
\enumerate{
\item The arguments passed to \code{epoxy_use_chunk()}, such as \code{.data} or any
arguments passed in the \code{...}. These options always have preference over
options set anywhere else.
\item The chunk options from the chunk where \code{epoxy_use_chunk()} or
\code{epoxy_use_file()} is called.
\item The chunk options from the template chunk or file. These options typically
are relevant to the template itself, such as the engine used or the
opening and closing delimiters.
\item Global knitr chunk options for the document. You can set these with
\code{knitr::opts_chunk$set()}, see \code{?knitr::opts_chunk} for more information.
}
}

\concept{Templating functions}
