% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlsx_from_Rdcm.R
\name{xlsx.from.Rdcm}
\alias{xlsx.from.Rdcm}
\title{Converting .Rdcm files to .xlsx files}
\usage{
xlsx.from.Rdcm(
  Rdcm.filenames,
  dest.dirname = dirname(Rdcm.filenames),
  txt.sep = "\\\\",
  txt.length = 100,
  tag.dictionary = dicom.tag.dictionary()
)
}
\arguments{
\item{Rdcm.filenames}{String vector, representing the *.Rdcm filenames to be
converted.}

\item{dest.dirname}{String vector of the same length as \code{Rdcm.filenames},
indicating the directory where the *.xlsx files will be created.}

\item{txt.sep}{String. Used if \code{as.txt = TRUE}. Separator of the tag value elements.}

\item{txt.length}{Positive integer. Used if \code{as.txt = TRUE}. Maximum number
of letters in the representation of the TAG value.}

\item{tag.dictionary}{Dataframe, by default equal to \link[espadon]{dicom.tag.dictionary},
whose structure it must keep. This dataframe is used to parse DICOM files.}
}
\value{
Returns a boolean vector, establishing the existence of the
created Excel files which have the same basenames as the *.Rdcm files.
}
\description{
A *.Rdcm file contains the list of contents, in dataframe form,
of the DICOM files of the same object.
The \code{xlsx.from.Rdcm} function creates, from a *.Rdcm file, an Excel file,
in which each page contains the dataframe representation of a DICOM file of
the same object.
}
\examples{
# First, create a Rdcm file from toy.dicom.raw () to a temporary file for testing.
pat.dir <- file.path (tempdir(), "PM_Rdcm") 
dir.create (pat.dir, recursive = TRUE) 
dcm.filename <- tempfile (pattern = "PM_rtplan", tmpdir = pat.dir, fileext = ".dcm")
zz <- file (dcm.filename, "wb")
writeBin (toy.dicom.raw (), zz, size = 1)
close (zz)
dicom.to.Rdcm.converter (dcm.filename, pat.dir, update = TRUE)
file.remove (dcm.filename)
list.files (pat.dir)

# Creating an Excel file
Rdcm.filenames <- list.files (pat.dir, pattern = "[.]Rdcm$",
                              recursive = TRUE, full.names = TRUE)
xlsx.from.Rdcm (Rdcm.filenames)
list.files (pat.dir)

# Cleaning temporary directory
unlink (pat.dir, recursive = TRUE)
}
