% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dppi_strategy.R
\name{dppi}
\alias{dppi}
\title{Dynamic Proportion Portfolio Insurance (DPPI)}
\usage{
dppi(q, tdate, f, tper, rper, tcost = 0, int = TRUE)
}
\arguments{
\item{q}{numeric value for quantity to be hedged, either positive (net buyer) or negative (net seller)}

\item{tdate}{date vector with trading days}

\item{f}{numeric futures price vector}

\item{tper}{numeric target price factor, markup/down to the price on the first trading day}

\item{rper}{numeric risk factor as a percentage of the price on the first trading day}

\item{tcost}{numeric transaction costs pr unit}

\item{int}{TRUE/FALSE integer restriction on tradable volume}
}
\value{
instance of the DPPI class
}
\description{
Implements DPPI strategy for commodity price risk management
}
\examples{
# DPPI for a buyer (seller), where stop loss is set 10\% above (below) initial market price.

set.seed(5)
# GBM price process parameters
mu <- 0.2
sigma <- 0.1
S0 <- 100

# time
Y <- 2
N <- 500
delta <- Y/N
t <- seq (0, 1, length = N + 1)

# price process and date vector
W <- c(0, cumsum ( sqrt(delta) * rnorm (N)))
f_gbm <- S0 * exp(mu * t + sigma * W)
tr_dates <- seq(Sys.Date(), Sys.Date()+500, by = "day")

# implement dppi strategy for buyer
dppi_b <- dppi(q = 10,
tdate = tr_dates,
f = f_gbm,
tper = 0.1,
rper = 0.1,
tcost = 0,
int = TRUE)

# implement dppi strategy for seller
dppi_s <- dppi(q = - 10,
tdate = tr_dates,
f = f_gbm,
tper = - 0.1,
rper = 0.1,
tcost = 0,
int = TRUE)

}
