% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qualtrics_data.R
\docType{data}
\name{qualtrics_raw}
\alias{qualtrics_raw}
\title{Example text-based metadata from simulated Qualtrics study}
\format{
A data frame with 102 rows and 16 variables:
\describe{
\item{StartDate}{date and time data collection started, in ISO 8601 format}
\item{EndDate}{date and time data collection ended, in ISO 8601 format}
\item{Status}{flag for preview (Survey Preview) vs. implemented survey
(IP Address) entries}
\item{IPAddress}{participant IP address (truncated for anonymity)}
\item{Progress}{percentage of survey completed}
\item{Duration (in seconds)}{duration of time required to complete survey,
in seconds}
\item{Finished}{logical for whether survey was completed (TRUE) or progress
was < 100 (FALSE)}
\item{RecordedDate}{date and time survey was recorded, in ISO 8601 format}
\item{ResponseId}{random ID for participants}
\item{LocationLatitude}{latitude geolocated from IP address}
\item{LocationLongitude}{longitude geolocated from IP address}
\item{UserLanguage}{language set in Qualtrics}
\item{Browser}{user web browser type}
\item{Version}{user web browser version}
\item{Operating System}{user operating system}
\item{Resolution}{user screen resolution}
}
}
\usage{
qualtrics_raw
}
\description{
A dataset containing the metadata from a standard Qualtrics survey with
browser metadata collected and exported with "Use choice text".
These data were randomly generated using \href{https://hrbrmstr.github.io/iptools/reference/ip_random.html}{iptools::ip_random()}
and \href{https://cran.r-project.org/src/contrib/Archive/rgeolocate/}{rgeolocate::ip2location()} functions.
This dataset includes the two header rows of with column information that is
exported by Qualtrics.
}
\seealso{
Other data: 
\code{\link{qualtrics_fetch}},
\code{\link{qualtrics_fetch2}},
\code{\link{qualtrics_numeric}},
\code{\link{qualtrics_text}}
}
\concept{data}
\keyword{datasets}
