% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandFunctions.R
\name{eMatrixOuter}
\alias{eMatrixOuter}
\title{Extends eOuter to allow a matrix for the first argument}
\usage{
eMatrixOuter(X, colParamVector, FUN, ...)
}
\arguments{
\item{X}{R object coercible to a matrix
the columns of this will be the
argument of FUN (see below).}

\item{colParamVector}{Vector input which will be the second
argument of FUN (see below).}

\item{FUN}{Function which will be applied to
FUN(X[,i],colParamVector[j],...)}

\item{...}{Additional arguments to FUN.}
}
\value{
Returns a matrix with the matrics generated by eOuter
for each column column bound together.  This means that each
row of the returned matrix represents single observations (at
least as long as no lags are used).
}
\description{
Extends eOuter to allow a matrix for the first argument
}
\details{
This function is a simple extension of eOuter which allows
the function eOuter(X[,i],colParamVector,FUN,...) for
i in the columns of X.
}
\examples{
A <- matrix(1:6,ncol=2)
temp <- eMatrixOuter(A,0:2,FUN=`^`)
}

