% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORGANISE__functions.R
\name{organise.message.removals}
\alias{organise.message.removals}
\title{Remove trials which fail to have all of the listed messages.}
\usage{
organise.message.removals(fixreport_df, required_message_list)
}
\arguments{
\item{fixreport_df}{Fixation report.}

\item{required_message_list}{List of messages required for each trial.}
}
\value{
A data.table detailing how many trials were removed from each session, plus a data.table with the cleaned fixation report.
}
\description{
Remove trials which fail to have all of the listed messages.
}
\examples{

data(fixationreport)
data(messagereport)


# REPLACE SPACES IN MESSAGES
messagereport <- organise.message.replace_spaces(messagereport)

# TAKE A LOOK
print(organise.message.descriptives(messagereport))

# MARKUP
fixationreport <- organise.message.markup(message_df=messagereport, 
                                          fixreport_df = fixationreport, message="DISPLAY_START")

fixationreport <- organise.message.markup(message_df=messagereport, 
                                          fixreport_df = fixationreport, message="DISPLAY_CHANGE")

# NOW DO ACCURACY AND RT MARKUP
fixationreport <- organise.responses.markup(fixationreport, "CORRECT_RESPONSE")

# NOW MARK UP FIXATION CONTINGENCIES
fixationreport<-organise.message.fix_contingencies(fixationreport, 
                                          list("DISPLAY_START", "DISPLAY_CHANGE", "RESPONSE_TIME"))
# SET UP TRUE RT
fixationreport[,TRUE_RT:=RESPONSE_TIME-DISPLAY_START,]

behaviouralData <- analyse.behavioural.data(fixationreport,
                                            aggregation_column_list = list('TRIALTYPE_TEXT'))

# RANDOM TRIAL TO CHECK THINGS OUT
print(organise.checks.random_trial(fixationreport))

# FIX CONTINGENCIES
print(organise.contingencies.descriptives(fixationreport))
messageRemovals <- organise.message.removals(fixreport_df=fixationreport, 
    required_message_list=list("DISPLAY_CHANGE", "RESPONSE_TIME"))

# LOOK AT MESSAGE REMOVALS
print(messageRemovals[[1]])

# GRAB THE FIXATION REPORT WITH TRIALS REMOVED
fixMessagesRemoved <- messageRemovals[[2]]

# THIS SHOWS WE HAVE NO UNCLASSIFIED FIXATIONS, GOOD!
print(organise.contingencies.descriptives(fixMessagesRemoved))
}
