% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ez_track.R
\name{ez_track}
\alias{ez_track}
\title{Create a Clean Tracking Object}
\usage{
ez_track(
  data,
  format = NULL,
  tz = "UTC",
  crs = 4326,
  as_sf = TRUE,
  id = NULL,
  timestamp = NULL,
  x = NULL,
  y = NULL,
  keep_original_cols = TRUE,
  subsample = "none",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{A tracking dataset or file path. Accepted types: `data.frame`, `sf`, `Spatial*`, or path to CSV, XLSX, SHP, or GPKG.}

\item{format}{Optional. File format to override detection. Choices: "csv", "xlsx", "shp", "gpkg".}

\item{tz}{Timezone for timestamps. Default is "UTC".}

\item{crs}{EPSG code or proj4string of the input CRS. Default is 4326 (WGS84).}

\item{as_sf}{Logical. Return an `sf` object? Default is TRUE.}

\item{id}{Optional. Column name for id.}

\item{timestamp}{Optional. Column name timestamp.}

\item{x}{Optional. Column name for longitude.}

\item{y}{Optional. Column name for latitude.}

\item{keep_original_cols}{Logical. If FALSE, drops non-standard columns and only retains `id`, `timestamp`, `x`, and `y`. Default is TRUE.}

\item{subsample}{Optional. Specify how many fixes to keep per time unit. You can use any positive integer and `"hour"` or `"day"` as the unit  (e.g.,`"1 per hour"` or `"2 per day"`).}

\item{verbose}{Logical. Print messages? Default is TRUE.}

\item{...}{Passed to the read function.}
}
\value{
A data.frame or `sf` object with columns `id`, `timestamp`, `x`, `y`.
}
\description{
Imports and standardizes tracking data into a tidy format with columns: `id`, `timestamp`, `x`, and `y`.
Supports input as data frames, `sf`, `Spatial*` objects, or file paths to CSV, Excel, Shapefiles, and GeoPackages.
Optionally returns a spatial object projected to WGS84 (EPSG:4326), and supports subsampling (e.g., "1 per hour").
}
