% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flags_to_nuis_spikes.R
\name{flags_to_nuis_spikes}
\alias{flags_to_nuis_spikes}
\title{Flags to nuisance spikes}
\usage{
flags_to_nuis_spikes(flags, n_time)
}
\arguments{
\item{flags}{Numeric vector of integers indicating the indices of
the flagged volumes. Or, a logical vector of length \code{n_time} where
\code{TRUE} values indicate the flagged volumes.}

\item{n_time}{The length of the vectors to obtain. For nuisance regression,
this is the length of the BOLD data. The highest index in \code{flags}
should not exceed \code{n_time}.}
}
\value{
A numeric matrix of ones and zeroes. The number of rows will be
\code{n_time} and the number of columns will be the number of flags. Each
column will have a \code{1} at the flag index, and \code{0} elsewhere.
}
\description{
Convert flagged volumes to corresponding one-hot encoded vectors
which can be used for nuisance regression.
}
