% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{forecast.fbl_prophet}
\alias{forecast.fbl_prophet}
\title{Produce forecasts from the prophet model}
\usage{
\method{forecast}{fbl_prophet}(object, new_data, specials = NULL, times = 1000, ...)
}
\arguments{
\item{object}{The time series model used to produce the forecasts}

\item{new_data}{A \code{tsibble} containing future information used to forecast.}

\item{specials}{(passed by \code{\link[fabletools:forecast]{fabletools::forecast.mdl_df()}}).}

\item{times}{The number of sample paths to use in estimating the forecast distribution when \code{boostrap = TRUE}.}

\item{...}{Additional arguments passed to \code{\link[prophet:predict.prophet]{prophet::predict.prophet()}}.}
}
\value{
A list of forecasts.
}
\description{
If additional future information is required (such as exogenous variables or
carrying capacities) by the model, then they should be included as variables
of the \code{new_data} argument.
}
\examples{

\donttest{
if (requireNamespace("tsibbledata")) {
library(tsibble)
tsibbledata::aus_production \%>\%
  model(
    prophet = prophet(Beer ~ season("year", 4, type = "multiplicative"))
  ) \%>\%
  forecast()
}
}

}
\seealso{
\code{\link[prophet:predict.prophet]{prophet::predict.prophet()}}
}
