% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{prophet}
\alias{prophet}
\title{Prophet procedure modelling}
\usage{
prophet(formula, ...)
}
\arguments{
\item{formula}{A symbolic description of the model to be fitted of class \code{formula}.}

\item{...}{Additional arguments passed to the \code{optimizing} or
\code{sampling} functions in Stan.}
}
\description{
Prepares a prophet model specification for use within the \code{fable} package.
}
\details{
The prophet modelling interface uses a \code{formula} based model specification
(\code{y ~ x}), where the left of the formula specifies the response variable,
and the right specifies the model's predictive terms. Like any model in the
fable framework, it is possible to specify transformations on the response.

A prophet model supports piecewise linear or exponential growth (trend),
additive or multiplicative seasonality, holiday effects and exogenous
regressors. These can be specified using the 'specials' functions detailed
below. The introduction vignette provides more details on how to model data
using this interface to prophet: \code{vignette("intro", package="fable.prophet")}.
}
\section{Specials}{


\subsection{growth}{
The \code{growth} special is used to specify the trend parameters.
\preformatted{
growth(type = c("linear", "logistic"), capacity = NULL, floor = NULL,
       changepoints = NULL, n_changepoints = 25, changepoint_range = 0.8,
       changepoint_prior_scale = 0.05)
}

\tabular{ll}{
\code{type}                    \tab The type of trend (linear or logistic).\cr
\code{capacity}                \tab The carrying capacity for when \code{type} is "logistic".\cr
\code{floor}                   \tab The saturating minimum for when \code{type} is "logistic".\cr
\code{changepoints}            \tab A vector of dates/times for changepoints. If \code{NULL}, changepoints are automatically selected.\cr
\code{n_changepoints}          \tab The total number of changepoints to be selected if \code{changepoints} is \code{NULL}\cr
\code{changepoint_range}       \tab Proportion of the start of the time series where changepoints are automatically selected.\cr
\code{changepoint_prior_scale} \tab Controls the flexibility of the trend.
}
}

\subsection{season}{
The \code{season} special is used to specify a seasonal component. This special can be used multiple times for different seasonalities.

\strong{Warning: The inputs controlling the seasonal \code{period} is specified is different than \code{\link[prophet:prophet]{prophet::prophet()}}. Numeric inputs are treated as the number of observations in each seasonal period, not the number of days.}

\preformatted{
season(period = NULL, order = NULL, prior_scale = 10,
       type = c("additive", "multiplicative"), name = NULL)
}

\tabular{ll}{
\code{period}      \tab The periodic nature of the seasonality. If a number is given, it will specify the number of observations in each seasonal period. If a character is given, it will be parsed using \code{lubridate::as.period}, allowing seasonal periods such as "2 years".\cr
\code{order}       \tab The number of terms in the partial Fourier sum. The higher the \code{order}, the more flexible the seasonality can be.\cr
\code{prior_scale} \tab Used to control the amount of regularisation applied. Reducing this will dampen the seasonal effect.\cr
\code{type}        \tab The nature of the seasonality. If "additive", the variability in the seasonal pattern is fixed. If "multiplicative", the seasonal pattern varies proportionally to the level of the series.\cr
\code{name}        \tab The name of the seasonal term (allowing you to name an annual pattern as 'annual' instead of 'year' or \code{365.25} for example).\cr
}
}

\subsection{holiday}{
The \code{holiday} special is used to specify a \code{tsibble} containing holidays for the model.
\preformatted{
holiday(holidays = NULL, prior_scale = 10L)
}

\tabular{ll}{
\code{holidays}    \tab A \href{https://tsibble.tidyverts.org/}{\code{tsibble}} containing a set of holiday events. The event name is given in the 'holiday' column, and the event date is given via the index. Additionally, "lower_window" and "upper_window" columns can be used to include days before and after the holiday.\cr
\code{prior_scale} \tab Used to control the amount of regularisation applied. Reducing this will dampen the holiday effect.\cr
}
}

\subsection{xreg}{
The \code{xreg} special is used to include exogenous regressors in the model. This special can be used multiple times for different regressors with different arguments.
Exogenous regressors can also be used in the formula without explicitly using the \code{xreg()} special, which will then use the default arguments.
\preformatted{
xreg(..., prior_scale = NULL, standardize = "auto", type = NULL)
}

\tabular{ll}{
\code{...}         \tab A set of bare expressions that are evaluated as exogenous regressors\cr
\code{prior_scale} \tab Used to control the amount of regularisation applied. Reducing this will dampen the regressor effect.\cr
\code{standardize} \tab Should the regressor be standardised before fitting? If "auto", it will standardise if the regressor is not binary.\cr
\code{type}        \tab Does the effect of the regressor vary proportionally to the level of the series? If so, "multiplicative" is best. Otherwise, use "additive"\cr
}
}
}

\examples{
library(tsibble)
as_tsibble(USAccDeaths) \%>\%
  model(
    prophet = prophet(value ~ season("year", 4, type = "multiplicative"))
  )

}
\seealso{
\itemize{
\item \code{\link[prophet:prophet]{prophet::prophet()}}
\item \href{https://facebook.github.io/prophet/}{Prophet homepage}
\item \href{https://CRAN.R-project.org/package=prophet}{Prophet R package}
\item \href{https://pypi.org/project/fbprophet/}{Prophet Python package}
}
}
