% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.ffm.R
\name{print.ffm}
\alias{print.ffm}
\title{Prints a fitted fundamental factor model}
\usage{
\method{print}{ffm}(x, digits = max(3, .Options$digits - 3), ...)
}
\arguments{
\item{x}{an object of class \code{ffm} produced by \code{fitFfm}.}

\item{digits}{an integer value, to indicate the required number of 
significant digits. Default is 3.}

\item{...}{optional arguments passed to the \code{print} method.}
}
\value{
Returns an object of class \code{print.ffm}.
}
\description{
S3 \code{print} method for object of class \code{ffm}. Prints 
the call, factor model dimension and summary statistics for the estimated
factor returns, cross-sectional r-squared values and residual variances 
from the fitted object. 

Refer to \code{\link{summary.ffm}} for a more detailed summary of the fit at 
each time period.
}
\examples{
\dontrun{
library(PCRA)
data(stocksCRSP)
data("factorDataSetDjia5Yrs")
# fit a fundamental factor model
fit.style.sector <- fitFfm(data=factorDataSetDjia5Yrs, 
                           asset.var="TICKER", 
                           ret.var="RETURN", 
                           date.var="DATE", 
                           exposure.vars = c("P2B", "MKTCAP"))
print(fit.style.sector)
}
}
\seealso{
\code{\link{fitFfm}}, \code{\link{summary.ffm}}
}
\author{
Yi-An Chen and Sangeetha Srinivasan
}
