% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repReturn.R
\name{repReturn}
\alias{repReturn}
\title{Portfolio return decomposition report}
\usage{
repReturn(
  ffmObj,
  weights = NULL,
  isPlot = TRUE,
  isPrint = TRUE,
  layout = NULL,
  scaleType = "free",
  stripLeft = TRUE,
  stripText.cex = 1,
  axis.cex = 1,
  digits = 1,
  titleText = TRUE,
  which = NULL,
  ...
)
}
\arguments{
\item{ffmObj}{an object of class ffm returned by fitFfm.}

\item{weights}{a vector of weights of the assets in the portfolio. Default is NULL.}

\item{isPlot}{logical variable to generate plot or not.}

\item{isPrint}{logical variable to print numeric summary or not.}

\item{layout}{layout is a numeric vector of length 2 or 3 giving the number of columns, rows, and pages (optional) in a multipanel display.}

\item{scaleType}{scaleType controls if use a same scale of y-axis, choose from c('same', 'free')}

\item{stripLeft}{logical variable to choose the position of strip, "TRUE" for drawing strips on the left of each panel, "FALSE" for drawing strips on the top of each panel. Used only when isPlot = 'TRUE'}

\item{stripText.cex}{a number indicating the amount by which strip text in the plot(s) should be scaled relative to the default. 1=default, 1.5 is 50\% larger, 0.5 is 50\% smaller, etc.}

\item{axis.cex}{a number indicating the amount by which axis in the plot(s) should be scaled relative to the default. 1=default, 1.5 is 50\% larger, 0.5 is 50\% smaller, etc.}

\item{digits}{digits of printout numeric summary. Used only when isPrint = 'TRUE'}

\item{titleText}{logical varible to choose display plot title or not. Default is 'TRUE', and used only when isPlot = 'TRUE'.}

\item{which}{a number to indicate the type of plot. If a subset of the plots 
is required, specify a subset of the numbers 1:4 for plots. If \code{which=NULL} (default), the following menu 
appears: \cr \cr
For plots of a group of assets: \cr
1 = Time Series plot of portfolio returns decomposition, \cr
2 = Time Series plot of portfolio style factors returns, \cr
3 = Time Series plot of portfolio sector returns, \cr
4 = Boxplot of Portfolio Factor Returns Components. \cr \cr}

\item{...}{other graphics parameters available in tsPlotMP(time series plot only) can be passed in through the ellipses}
}
\value{
A K x 2 matrix containing mean and standard deviation of K factors
}
\description{
Decompostite return of portfolio into return of different factors based on fundamental factor model. This method takes fundamental factor model fit, "ffm" object, and portfolio weight as inputs and generates numeric summary and plot visualization.
}
\examples{
args(repReturn)
}
\author{
Douglas Martin, Lingjie Yi
}
