% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fac2x2design.R
\name{fac2x2design}
\alias{fac2x2design}
\title{Power for the Equal Allocation 3, Proportional Allocation 2, and
Equal Allocation 2 procedures.}
\usage{
fac2x2design(
  n,
  rateC,
  hrA,
  hrB,
  hrAB,
  mincens,
  maxcens,
  dig = 2,
  alpha = 0.05,
  niter = 5,
  abseps = 0.001,
  corAa = 1/sqrt(2),
  corAab = 1/sqrt(2),
  coraab = 1/2
)
}
\arguments{
\item{n}{total sample size}

\item{rateC}{group C one year event rate}

\item{hrA}{group A to group C hazard ratio}

\item{hrB}{group B to group C hazard ratio}

\item{hrAB}{group AB to group C hazard ratio}

\item{mincens}{minimum censoring time}

\item{maxcens}{maximum censoring time}

\item{dig}{number of decimal places to \code{\link{roundDown}} the critical value to}

\item{alpha}{two-sided significance level}

\item{niter}{number of times we call \code{pmvnorm} to average out its randomness}

\item{abseps}{\code{abseps} setting in the \code{pmvnorm} call}

\item{corAa}{correlation between the overall A and simple A log hazard ratio estimates}

\item{corAab}{correlation between the overall A and simple AB log hazard ratio estimates}

\item{coraab}{correlation between the simple A and simple AB log hazard ratio estimates}
}
\value{
\item{events}{expected number of events}

\item{evtprob}{event probabilities for the C, A, B, and AB groups, respectively}

\item{powerEA3overallA }{Equal Allocation 3's power to detect the overall A effect}

\item{powerEA3simpleA }{Equal Allocation 3's power to detect the simple A effect}

\item{powerEA3simpleAB }{Equal Allocation 3's power to detect the simple AB effect}

\item{powerEA3anyA }{Equal Allocation 3's power to detect the simple A or AB effects}

\item{powerPA2overallA }{Proportional Allocation 2's power to detect the overall A effect}

\item{powerPA2simpleAB }{Proportional Allocation 2's power to detect the simple AB effect}

\item{powerEA2simpleA }{Equal Allocation 2's power to detect the simple A effect}

\item{powerEA2simpleAB }{Equal Allocation 2's power to detect the simple AB effect}

\item{powerA}{power to detect the overall A effect at the two-sided \code{alpha} level}

\item{powerB}{power to detect the overall B effect at the two-sided \code{alpha} level}
}
\description{
Power for the Equal Allocation 3, Proportional Allocation 2, and
Equal Allocation 2 procedures.
}
\examples{
# Corresponds to scenario 4 in Table 2 from Leifer, Troendle, et al. (2019).
n <- 4600
rateC <- 0.0445
hrA <- 0.80
hrB <- 0.80
hrAB <- 0.72
mincens <- 4.0
maxcens <- 8.4

fac2x2design(n, rateC, hrA, hrB, hrAB, mincens, maxcens, dig = 2, alpha = 0.05, niter = 1)
# $events
# [1] 954.8738

# $evtprob
# probC     probA     probB    probAB
# 0.2446365 0.2012540 0.2012540 0.1831806

# $powerEA3overallA
# [1] 0.5861992

# $powerEA3simpleA
# [1] 0.5817954

# $powerEA3simplAB
# [1] 0.9071236

# $powerEA3anyA
# [1] 0.7060777
# $powerPA2overallA
# [1] 0.6582819

# $powerPA2simpleAB
# [1] 0.9197286

# $powerEA2simpleA
# [1] 0.6203837
#
# $powerEA2simpleAB
# [1] 0.9226679

# $powerA
# [1] 0.7182932

# $powerB
# [1] 0.7182932

}
\references{
Leifer, E.S., Troendle, J.F., Kolecki, A., Follmann, D.
Joint testing of overall and simple effect for the two-by-two factorial design. (2019). Submitted.

Slud, E.V. Analysis of factorial survival experiments. Biometrics. 1994; 50: 25-38.
}
\seealso{
\code{\link{eventProb}}, \code{\link{crit2x2}}, \code{\link{lgrkPower}}
\code{\link{strLgrkPower}}, \code{\link{powerEA3}}, \code{\link{powerPA2}},
\code{\link{powerEA2}}
}
