% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_dst-family_wrappers.R
\name{fit_dst_family_wrappers}
\alias{fit_dst_family_wrappers}
\alias{fit_dst_bern}
\alias{fit_dst_beta}
\alias{fit_dst_cauchy}
\alias{fit_dst_chisq}
\alias{fit_dst_degenerate}
\alias{fit_dst_empirical}
\alias{fit_dst_exp}
\alias{fit_dst_f}
\alias{fit_dst_finite}
\alias{fit_dst_gamma}
\alias{fit_dst_geom}
\alias{fit_dst_gev}
\alias{fit_dst_gp}
\alias{fit_dst_gumbel}
\alias{fit_dst_lnorm}
\alias{fit_dst_lp3}
\alias{fit_dst_nbinom}
\alias{fit_dst_norm}
\alias{fit_dst_null}
\alias{fit_dst_pearson3}
\alias{fit_dst_pois}
\alias{fit_dst_t}
\alias{fit_dst_unif}
\alias{fit_dst_weibull}
\title{Fit Distributions by Family}
\usage{
fit_dst_bern(x, method = c("mle", "lmom"), ...)

fit_dst_beta(x, method = c("mle", "mge", "mme"), ...)

fit_dst_cauchy(x, method = c("mle", "mge"), ...)

fit_dst_chisq(x, method = c("mle", "mge", "lmom"), ...)

fit_dst_degenerate(x, method = "mle", ...)

fit_dst_empirical(x, ...)

fit_dst_exp(x, method = c("mle", "mge", "mme", "lmom"), ...)

fit_dst_f(x, method = c("mle", "mge"), ...)

fit_dst_finite(x, ...)

fit_dst_gamma(x, method = c("mle", "mge", "mme", "lmom"), ...)

fit_dst_geom(x, method = c("mle", "mme", "lmom"), ...)

fit_dst_gev(x, method = c("mle", "lmom"), ...)

fit_dst_gp(x, method = c("mle", "lmom"), ...)

fit_dst_gumbel(x, method = c("mle", "lmom"), ...)

fit_dst_lnorm(x, method = c("mle", "mge", "mme", "lmom", "lmom-log"), ...)

fit_dst_lp3(x, method = "lmom-log", ...)

fit_dst_nbinom(x, method = c("mle", "mme"), ...)

fit_dst_norm(x, method = c("mle", "mge", "mme", "lmom"), ...)

fit_dst_null(x, ...)

fit_dst_pearson3(x, method = "lmom", ...)

fit_dst_pois(x, method = c("mle", "mme", "lmom"), ...)

fit_dst_t(x, method = c("mle", "mge"), ...)

fit_dst_unif(x, method = c("mle", "mge", "mme", "lmom"), ...)

fit_dst_weibull(x, method = c("mle", "mge", "lmom"), ...)
}
\arguments{
\item{x}{Numeric vector of observations to fit.}

\item{method}{Estimation method to use. Available options depend on the
distribution family and are enforced via \code{rlang::arg_match()}.}

\item{...}{Additional arguments passed on to \code{fit_dst()}.}
}
\value{
A distribution object made by the 'distionary' package.
}
\description{
Convenience wrappers around \code{fit_dst()} for each distribution family
supported by the package.
}
\details{
Each helper simply forwards to \code{fit_dst()} with the associated \code{family}
value indicated by the function suffix.

Some families do not have a unique fitting method where it is not applicable.
These are the 'finite' ones (including 'degenerate' and 'empirical'), and
the 'Null' distribution.
\subsection{Missing Combinations}{

Some combinations of families and methods are not supported,
when one might think that they should be. These combinations are:
\itemize{
\item 'gp' fit by 'mge'
\item 'lp3' fit by 'mle' and 'mge'
\item 'pearson3' fit by 'mle' and 'mge'
\item 'gev' fit by 'mge'
}

They are not included because of how the \code{fitdistrplus::fitdist()} function
looks for those distributional representations (i.e., \code{plp3()}, \code{dlp3()},
etc.): since we cannot guarantee that it will find the correct ones, these
combinations are omitted for safety.

To elaborate, the current version of the wrapped \code{fitdistrplus::fitdist()}
function looks for these representations starting from the
\code{namespace:fitdistrplus} environment. \code{famish} cannot control what's
found in that search path
until the global environment, but that's too late because that's where
behaviour becomes conditional on the user's actions. This is not a problem
for other distributions because these are found in the \code{namespace:base}
environment before the global environment is reached.
}
}
\examples{
# Calls can be quite simple.
fit_dst_norm(1:10)
fit_dst_gumbel(2:6)

# Still have access to the functionality available through `fit_dst()`
x <- c(1, 4, 3, NA, 5)
fit_dst_lnorm(x, method = "lmom", na_action = "null")
fit_dst_lnorm(x, method = "lmom", na_action = "drop")

# Fitting by l-moments on the log-scale not the same as original scale.
fit_dst_lnorm(x, method = "lmom-log", na_action = "drop")
}
\seealso{
\code{\link[=fit_dst]{fit_dst()}}
}
