% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Kids}
\alias{Kids}
\title{Goals and popularity factors for school kids}
\format{
A data frame with 478 observations on the following 11 variables.
\describe{ 
\item{gender}{ a factor with levels \code{boy}
\code{girl}} 
\item{grade}{ grade in school}
\item{age}{ student age} 
\item{race}{ a factor with levels
\code{other} \code{White}} 
\item{urban.rural}{ a factor with levels
\code{Rural} \code{Suburban} \code{Urban}} 
\item{school}{ a factor
with levels \code{Brentwood Elementary} \code{Brentwood Middle} \code{Brown
Middle} \code{Elm} \code{Main} \code{Portage} \code{Ridge} \code{Sand}
\code{Westdale Middle}} 
\item{goals}{ a factor with levels
\code{Grades} \code{Popular} \code{Sports}} 
\item{grades}{ rank of
`make good grades' (1 = most important for popularity; 4 = least important)}
\item{sports}{ rank of `beging good at sports' (1 = most important for
popularity; 4 = least important)} 
\item{looks}{ rank of `beging
handsome or pretty' (1 = most important for popularity; 4 = least important)}
\item{money}{ rank of `having lots of money' (1 = most important for
popularity; 4 = least important)} }
}
\source{
These data are available at DASL, the data and story library
(\url{https://dasl.datadescription.com/}).
}
\description{
Subjects were students in grades 4-6 from three school districts in
Michigan. Students were selected from urban, suburban, and rural school
districts with approximately 1/3 of their sample coming from each district.
Students indicated whether good grades, athletic ability, or popularity was
most important to them.  They also ranked four factors: grades, sports,
looks, and money, in order of their importance for popularity.  The
questionnaire also asked for gender, grade level, and other demographic
information.
}
\examples{

data(Kids)
tally(goals ~ urban.rural, data = Kids)
chisq.test(tally(~ goals + urban.rural, data = Kids))

}
\references{
Chase, M. A., and Dummer, G. M. (1992), "The Role of Sports as a
Social Determinant for Children," Research Quarterly for Exercise and Sport,
63, 418-424.
}
\keyword{datasets}
