% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nckqr-methods.R
\name{coef.nckqr}
\alias{coef.nckqr}
\title{Extract model coefficients from a `nckqr` object.}
\usage{
\method{coef}{nckqr}(object, s1 = NULL, s2, ...)
}
\arguments{
\item{object}{A fitted \code{nckqr} object.}

\item{s1}{Value(s) of the penalty parameter `lambda1` at which
coefficients are required. Default is the entire sequence used to create the
model.}

\item{s2}{Value of the penalty parameter `lambda2` at which
coefficients are required.}

\item{...}{Not used.}
}
\value{
The coefficients for the non-crossing kernel quantile regression model.
}
\description{
Computes the coefficients at the requested value(s) for `lambda1` for a given
'lambda2' from a [nckqr()] object.
}
\details{
`s1` is the new vector of `lambda1` values at which predictions are requested.
If `s1` is not in the lambda sequence used for fitting the model, the `coef`
function will use linear interpolation to make predictions. The new values
are interpolated using a fraction of coefficients from both left and right
`lambda` indices.
}
\examples{
library(MASS)
data(GAGurine)
x <- as.matrix(GAGurine$Age)
y <- GAGurine$GAG
l2 <- 1e-4
ttau <- c(0.1, 0.3, 0.5, 0.7, 0.9)
l1_list <- 10^seq(-8, 2, length.out=10)
\donttest{fit <- nckqr(x,y, lambda1=l1_list, lambda2=l2, tau=ttau)}
\donttest{coef(fit, s1=l1_list[1:3], s2=1e-4)}
}
\seealso{
[nckqr()] and [predict.nckqr()].
}
