% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_expand.R
\name{f_expand}
\alias{f_expand}
\alias{f_complete}
\alias{crossing}
\alias{nesting}
\title{Fast versions of \code{tidyr::expand()} and \code{tidyr::complete()}.}
\usage{
f_expand(.data, ..., .sort = FALSE, .by = NULL, .cols = NULL)

f_complete(.data, ..., .sort = FALSE, .by = NULL, .cols = NULL, fill = NA)

crossing(..., .sort = FALSE)

nesting(..., .sort = FALSE)
}
\arguments{
\item{.data}{A data frame}

\item{...}{Variables to expand.}

\item{.sort}{Logical. If \code{TRUE} expanded/completed variables are sorted.
The default is \code{FALSE}.}

\item{.by}{(Optional). A selection of columns to group by for this operation.
Columns are specified using tidy-select.}

\item{.cols}{(Optional) alternative to \code{...} that accepts
a named character vector or numeric vector.
If speed is an expensive resource, it is recommended to use this.}

\item{fill}{A named list containing value-name pairs
to fill the named implicit missing values.}
}
\value{
A \code{data.frame} of expanded groups.
}
\description{
Fast versions of \code{tidyr::expand()} and \code{tidyr::complete()}.
}
\details{
\code{crossing} and \code{nesting} are helpers that are basically identical to
tidyr's \code{crossing} and \code{nesting}.
}
