% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcirt.R
\name{fcirt}
\alias{fcirt}
\title{forced choice model estimation}
\usage{
fcirt(
  fcirt.Data,
  pairmap,
  ind,
  ParInits,
  model = "MUPP",
  covariate = NULL,
  iter = 3000,
  chains = 3,
  warmup = floor(iter/2),
  adapt_delta = 0.9,
  max_treedepth = 15,
  thin = 1,
  cores = 2,
  ma = 0,
  va = 0.5,
  md = 0,
  vd = 1,
  mt = 0,
  vt = 2
)
}
\arguments{
\item{fcirt.Data}{Response data in wide format. If the first statement is preferred, the data should be coded as 1, otherwise it should be coded as 2.}

\item{pairmap}{A two-column data matrix: the first column is the statement number for statement s; the second column is the statement number for statement t.}

\item{ind}{A column vector mapping each statement to each trait. For example, c(1, 1, 1, 2, 2, 2) means that the first 3 statements belong to trait 1 and the last 3 statements belong to trait 2.}

\item{ParInits}{A three-column matrix containing initial values for the three statement parameters. If using the direct MUPP estimation approach, 1 and -1 for alphas and taus are recommended and -1 or 1 for deltas are recommended depending on the signs of the statements. If using the two-step estimation approach, pre-estimated statement parameters are used as the initial values. The R package bmggum can be used to estimate statement parameters for the two-step approach. See documentation for bmggum for more details.}

\item{model}{Models fitted. They can be "MUPP". The default is MUPP (Multi-Unidimensional Pairwise Preference) model.}

\item{covariate}{An p*c person covariate matrix where p equals sample size and c equals the number of covariates. The default is NULL, meaning no person covariate.}

\item{iter}{The number of iterations. The default value is 3000. See documentation for rstan for more details.}

\item{chains}{The number of chains. The default value is 3. See documentation for rstan for more details.}

\item{warmup}{The number of warmups to discard. The default value is 0.5*iterations. See documentation for rstan for more details.}

\item{adapt_delta}{Target average proposal acceptance probability during Stan's adaptation period. The default value is 0.90. See documentation for rstan for more details.}

\item{max_treedepth}{Cap on the depth of the trees evaluated during each iteration. The default value is 15. See documentation for rstan for more details.}

\item{thin}{Thinning. The default value is 1. See documentation for rstan for more details.}

\item{cores}{The number of computer cores used for parallel computing. The default value is 2.}

\item{ma}{Mean of the prior distribution for alphas, which follows a lognormal distribution. The default value is 0.}

\item{va}{Standard deviation of the prior distribution for alpha. The default value is 0.5.}

\item{md}{Mean of the prior distribution for deltas, which follows a normal distribution. The default value is 0.}

\item{vd}{Standard deviation of the prior distribution for deltas. The default value is 1.}

\item{mt}{Means of the prior distributions for taus, which follows a normal distribution. The default values is 0.}

\item{vt}{Standard deviation of the prior distribution for taus. The default value is 2.}
}
\value{
Result object that stores information including the (1) stanfit object, (2) estimated item parameters, (3) estimated person parameters, (4) response data, and (5) the input column vector mapping each statement to each trait.
}
\description{
This function implements full Bayesian estimation of forced choice models using rstan
}
\examples{
\donttest{
# long running time
Data <- c(1,2,2,1,1,1,1,1,NA,1,2,1,1,2,1,1,2,2,NA,2,2,2,1,1,1,2,1,1,1,1,2,1,1,1,2,1,1,2,1,1)
Data <- matrix(Data,nrow = 10)
pairmap <- c(1,3,5,7,2,4,6,8)
pairmap <- matrix(pairmap,ncol = 2)
ind <- c(1,2,1,2,1,2,2,1)
ParInits <- c(1, 1, 1, 1, 1, 1, 1, 1, 1, -1, 1, 1, 1, -1, 1, 1, -1, -1, -1, -1, -1, -1, -1, -1)
ParInits <- matrix(ParInits, ncol = 3)
mod <- fcirt(fcirt.Data=Data,pairmap=pairmap,ind=ind,
ParInits=ParInits,iter=1000,warmup=500,chains=2)}
}
