% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_misc.R
\name{ft_filter_func}
\alias{ft_filter_func}
\title{Filter Factor Levels Using a Function}
\usage{
ft_filter_func(factor_vec, func)
}
\arguments{
\item{factor_vec}{A factor vector to filter.}

\item{func}{A function that takes a character vector of levels and returns a logical vector.}
}
\value{
A factor vector with levels filtered according to the function.
}
\description{
Removes levels from a factor vector based on a user-defined  function.
}
\examples{
# Example factor vector
factor_vec <- factor(c('apple', 'banana', 'cherry', 'date'))

# Remove levels that start with 'b'
ft_filter_func(factor_vec, function(x) !grepl('^b', x))
}
\author{
Kai Guo
}
