% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_misc.R
\name{ft_len}
\alias{ft_len}
\title{Sort Factor Levels Based on Their Length}
\usage{
ft_len(factor_vec, decreasing = FALSE, inplace = FALSE)
}
\arguments{
\item{factor_vec}{A factor vector to be sorted.}

\item{decreasing}{Logical. Should the ordering be decreasing by length? Default is \code{FALSE}.}

\item{inplace}{Logical. If \code{TRUE}, returns a new factor vector with elements reordered to align with the new levels' order. If \code{FALSE}, returns a new factor vector with levels reordered based on their length without changing the data vector's elements' order. Defaults to \code{FALSE}.}
}
\value{
A factor vector with levels reordered based on their length. Depending on the \code{inplace} parameter, the data vector's elements may also be reordered.
}
\description{
Reorders the levels of a factor vector based on the character length of each level. Optionally reorders the data vector's elements to align with the new levels' order.
}
\examples{
# Example factor vector
factor_vec <- factor(c('apple', 'banana', 'cherry', 'date'))

# Sort levels by length without reordering data elements
sorted_factor <- ft_len(factor_vec)
print(sorted_factor)
# [1] apple  banana cherry date
# Levels: apple date banana cherry

# Sort levels by length and reorder data elements
sorted_factor_inplace <- ft_len(factor_vec, inplace = TRUE)
print(sorted_factor_inplace)
# [1] date   apple  banana cherry
# Levels: apple date banana cherry
}
\author{
Kai Guo
}
