% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_fct.R
\name{ft_merge_similar}
\alias{ft_merge_similar}
\title{Merge Similar Factor Levels}
\usage{
ft_merge_similar(factor_vec, max_distance = 1, method = "lv")
}
\arguments{
\item{factor_vec}{A factor vector to modify.}

\item{max_distance}{A numeric value specifying the maximum string distance for merging levels.}

\item{method}{The method for computing string distance (default is 'lv' for Levenshtein distance).}
}
\value{
A factor vector with similar levels merged.
}
\description{
Merges levels of a factor that are similar based on string distance.
}
\examples{
# Example factor vector
factor_vec <- factor(c('apple', 'appel', 'banana', 'bananna', 'cherry'))

# Merge similar levels
ft_merge_similar(factor_vec, max_distance = 1)
}
\author{
Kai Guo
}
