% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_distribution.R
\name{estimate_iid_distr_MC}
\alias{estimate_iid_distr_MC}
\title{Estimate distribution of the fACF under the iid. hypothesis using MC method}
\usage{
estimate_iid_distr_MC(Y, v, autocovSurface, matindex, nsimul = 10000,
  figure = FALSE, ...)
}
\arguments{
\item{Y}{Matrix containing the discretized values
of the functional time series. The dimension of the
matrix is \eqn{(n x m)}, where \eqn{n} is the
number of curves and \eqn{m} is the number of points
observed in each curve.}

\item{v}{Discretization points of the curves, by default
\code{seq(from = 0, to = 1, length.out = 100)}.}

\item{autocovSurface}{An \eqn{(m x m)} matrix with the discretized
values of the autocovariance operator \eqn{\hat{C}_{0}}, obtained
by calling the function \code{obtain_autocovariance}.
The value \eqn{m} indicates the number of points observed
in each curve.}

\item{matindex}{A vector containing the L2 norm of
the autocovariance function. It can be obtained by calling
function \code{obtain_suface_L2_norm}.}

\item{nsimul}{Positive integer indicating the number of
MC simulations that will be used to estimate the distribution
of the statistic. Increasing the number of simulations will
improve the estimation, but it will increase the computational
time.
By default, \code{nsimul = 10000}.}

\item{figure}{Logical. If \code{TRUE}, plots the
estimated distribution.}

\item{...}{Further arguments passed to the  \code{plot}
function.}
}
\value{
Return a list with:
\itemize{
    \item \code{ex}: Knots where the
    distribution has been estimated
    \item \code{ef}: Discretized values of
    the estimated distribution.
    \item \code{Reig}: Raw values of the i.i.d.
    statistic for each MC simulation.
}
}
\description{
Estimate the distribution of the autocorrelation function
under the hypothesis of strong functional white noise. This
function uses Montecarlo's method to estimate the distribution.
}
\examples{
# Example 1

N <- 100
v <- seq(from = 0, to = 1, length.out = 10)
sig <- 2
Y <- simulate_iid_brownian_bridge(N, v, sig)
nlags <- 1
autocovSurface <- obtain_autocovariance(Y,nlags)
matindex <- obtain_suface_L2_norm (v,autocovSurface)
# Remove lag 0
matindex <- matindex[-1]
MC_dist <- estimate_iid_distr_MC(Y,v,autocovSurface,matindex)
plot(MC_dist$ex,MC_dist$ef,type = "l",main = "ecdf obtained by MC simulation")
grid()

\donttest{
# Example 2

N <- 400
v <- seq(from = 0, to = 1, length.out = 50)
sig <- 2
Y <- simulate_iid_brownian_bridge(N, v, sig)
nlags <- 20
autocovSurface <- obtain_autocovariance(Y,nlags)
matindex <- obtain_suface_L2_norm (v,autocovSurface)
# Remove lag 0
matindex <- matindex[-1]
MC_dist <- estimate_iid_distr_MC(Y,v,autocovSurface,matindex)
plot(MC_dist$ex,MC_dist$ef,type = "l",main = "ecdf obtained by MC simulation")
grid()
}
}
