% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depthbasedreconstructPOFD.R
\name{depthbasedreconstructionPOFD}
\alias{depthbasedreconstructionPOFD}
\title{Depth-based reconstruction of partially observed functional data}
\usage{
depthbasedreconstructionPOFD(data, id_recons = 1:dim(data)[2])
}
\arguments{
\item{data}{Data matrix `p` by `n`, being `n` the number of functions and `p` the number of grid points.
The row names of the matrix should be the common evaluation grid and the column names the identifiers of each functional data.}

\item{id_recons}{Vector indicating functions to be reconstructed. By default, all functions are reconstructed.}
}
\value{
The reconstructed data matrix 'recons_data'.
}
\description{
This function implements the reconstruction procedure [1]
which is based on the depth measure [2] for partially observed functional
data. Missing trajectories are imputed by the mean of the k nearest
neighbors within the envelope. The parameter k is tuned minimizing the Mean Squared Error of the
reconstruction in the observed part of the curve.
}
\details{
[1] Elías, A., Jiménez, R., & Shang, H. L. (2023). Depth-based reconstruction
method for incomplete functional data. Computational Statistics, 38(3),
1507-1535.

[2] Elías, A., Jiménez, R., Paganoni, A. M., & Sangalli, L. M. (2023).
Integrated depths for partially observed functional data. Journal of
Computational and Graphical Statistics, 32(2), 341-352.
}
\examples{
data <- exampleData$PoFDintervals
recons_data <- depthbasedreconstructionPOFD(data, id_recons = 1:2)

}
