% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CI_sparse_FCReg.R
\name{GetCI_Sparse}
\alias{GetCI_Sparse}
\title{Bootstrap pointwise confidence intervals for the coefficient functions in functional concurrent regression for sparsely observed data.}
\usage{
GetCI_Sparse(
  vars,
  outGrid = NULL,
  level = 0.95,
  R = 999,
  userBwMu = NULL,
  userBwCov = NULL,
  kern = "gauss",
  measurementError = FALSE,
  diag1D = "all",
  useGAM = FALSE
)
}
\arguments{
\item{vars}{A list of input functional/scalar covariates.
Each field corresponds to a functional (a list) or scalar (a vector) covariate.
The last entry is assumed to be the response if no entry is named 'Y'.
If a field corresponds to a functional covariate, it should have two fields: 'Lt', a list of time points, and 'Ly', a list of functional values.}

\item{outGrid}{A vector with the output time points, which need to be within 5\% and 95\% of the range of functional covariates. If NULL, outGrid will be generated from 5\% to 95\% of the range of functional covariates with 51 grids for fitting. Default: NULL}

\item{level}{A number taking values in [0,1] determining the confidence level. Default: 0.95.}

\item{R}{An integer holding the number of bootstrap replicates. Default: 999.}

\item{userBwMu}{A scalar/vector bandwidth used for smoothing the mean function. Each entry in the vector represents the bandwidth used for the corresponding covariate in vars. For the scalar covariates, you can input 0 as a placeholder. If you only input a scalar, the function will use the same bandwidth to smooth all mean functions. --- a scalar/vector of positive numeric -
default: NULL --- if no scalar/vector value is provided, the bandwidth value for the smoothed mean function is chosen using 'GCV';}

\item{userBwCov}{A scalar/vector bandwidth used for smoothing the auto or cross-covariances. If you use 1D smoothing for the diagonal line of the covariance (diag1D="all"), only one scalar input is needed. If you use 2D smoothing for the covariance (diag1D="none"), a vector of bandwidth is required. Each entry in the vector represents the bandwidth used for the corresponding covariate in vars. For the scalar covariates, you can input 0 as a placeholder. --- a scalar/vector of positive numeric -
default: NULL --- if no scalar/vector is provided, the bandwidth value for the smoothed cross-covariance function is chosen using 'GCV';}

\item{kern}{Smoothing kernel choice, common for mu and covariance;
"rect", "gauss", "epan", "gausvar", "quar" (default: "gauss")}

\item{measurementError}{Assume measurement error in the data; logical - default: FALSE. If TRUE the diagonal raw covariance will be removed when smoothing.}

\item{diag1D}{A string specifying whether to use 1D smoothing for the diagonal line of the covariance.
'none': don't use 1D smoothing; 'all': use 1D for both auto- and cross-covariances. (default : 'all')}

\item{useGAM}{Use GAM smoothing instead of local linear smoothing (semi-parametric option);  logical - default: FALSE.}
}
\value{
A list containing the following fields:
\describe{
\item{CI_beta0}{CI for the intercept function --- A data frame holding three variables:
\code{CIgrid} --- the time grid where the CIs are evaluated,
\code{CI_beta0.lower} and \code{CI_beta0.upper} --- the lower and upper bounds of the CIs
for the intercept function on \code{CIgrid}.}

\item{CI_beta}{ A list containing CIs for the slope functions --- the length of
the list is same as the number of covariates. Each list contains the following fields:
A data frame holding three variables: \code{CIgrid} --- the time grid where the CIs are evaluated,
\code{CI_beta_j.lower} and \code{CI_beta_j.upper} --- the lower and upper bounds of the CIs
for the coefficient functions on \code{CIgrid} for \eqn{j = 1,2,\dots}.}

\item{CI_R2}{CI the time-varying \eqn{R^2(t)} --- A data frame holding three variables:
\code{CIgrid} --- the time grid where the CIs are evaluated,
\code{CI_R2.lower} and \code{CI_R2.upper} --- the lower and upper bounds of the CIs
for the time-varying \eqn{R^2(t)} on \code{CIgrid}.}

\item{level}{The confidence level of the CIs.}
}
}
\description{
Bootstrap pointwise confidence intervals for the coefficient functions in functional concurrent regression for sparsely observed data.
}
\details{
If measurement error is assumed, the diagonal elements of the raw covariance will be removed. This could result in highly unstable estimate
if the design is very sparse, or strong seasonality presents.
WARNING! For very sparse functional data, setting measurementError = TRUE is not recommended.
}
\examples{

set.seed(1)
n <- 30
nGridIn <- 100
sparsity <- 5:10 # Sparse data sparsity
T <- round(seq(0, 1, length.out=nGridIn), 4) # Functional data support
bw <- 0.1
outGrid <- round(seq(min(T), 1, by=0.05), 2)
# Simulate functional data
mu <- T * 2 # mean function for X_1
sigma <- 1

beta_0 <- 0
beta <- rbind(cos(T), 1.5 + sin(T))
beta_2 <- 1

Z <- MASS::mvrnorm(n, rep(0, 2), diag(2))
X_1 <- Z[, 1, drop=FALSE] \%*\% matrix(1, 1, nGridIn) + matrix(mu, n, nGridIn, byrow=TRUE)
epsilon <- rnorm(n, sd=sigma)
Y <- matrix(NA, n, nGridIn)
for (i in seq_len(n)) {
  Y[i, ] <- beta_0 + beta[1,] * X_1[i, ] + beta[2,] * Z[i, 2] + epsilon[i]
}

# Sparsify functional data
set.seed(1)
X_1sp <- fdapace::Sparsify(X_1, T, sparsity)
Ysp <- fdapace::Sparsify(Y, T, sparsity)
vars <- list(X_1=X_1sp, Z_2=Z[, 2], Y=Ysp)
res <-  GetCI_Sparse(vars, outGrid[-c(1,21)], level = 0.95, R = 2,
                     userBwMu = c(.1,.1,.1), userBwCov = c(.1,.1,.1),
                     kern='gauss', measurementError=TRUE, diag1D='none',
                     useGAM = FALSE)
}
