% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/association.R
\name{predict.apriori}
\alias{predict.apriori}
\title{Model predictions}
\usage{
\method{predict}{apriori}(object, test, unmatched = "Unknown", ...)
}
\arguments{
\item{object}{The classification model (of class \code{apriori}, created by \code{apriori.classif}).}

\item{test}{The test set (a \code{data.frame})}

\item{unmatched}{The class label given to the unmatched observations (a character string).}

\item{...}{Other parameters.}
}
\value{
A vector of predicted values (\code{factor}).
}
\description{
This function predicts values based upon a model trained by \code{apriori.classif}.
Observations that do not match any of the rules are labelled as "unmatched".
}
\examples{
require ("datasets")
data (iris)
d = discretizeDF (iris,
    default = list (method = "interval", breaks = 3, labels = c ("small", "medium", "large")))
model = APRIORI (d [, -5], d [, 5], supp = .1, conf = .9, prune = TRUE)
predict (model, d [, -5])
}
\seealso{
\code{\link{APRIORI}}, \code{\link{apriori-class}}, \code{\link[arules]{apriori}}
}
