% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdp.R
\name{+.fdp_plot}
\alias{+.fdp_plot}
\title{Combine fdp plots}
\usage{
\method{+}{fdp_plot}(e1, e2)
}
\arguments{
\item{e1}{An \code{fdp_plot} object (the result of calling \code{fdp()})}

\item{e2}{Either another \code{fdp_plot} object or a \code{ggplot2} layer}
}
\value{
If \code{e2} is an \code{fdp_plot}, returns a new combined \code{fdp_plot} object.
If \code{e2} is a \code{ggplot2} layer, returns a modified \code{ggplot2} object.
}
\description{
Allows combining multiple \code{fdp()} plot objects using the \code{+} operator.
}
\examples{
# Combine two separate fdp() calls
fdp(gdp(0.5)) + fdp(lap(1))

# Can still add regular ggplot2 layers
fdp(gdp(1)) + ggplot2::ggtitle("My Privacy Plot")

# First legend naming takes precedence
fdp(gdp(0.5), .legend = "First") + fdp(lap(1), .legend = "Second")
# Later .legend arguments apply if none specified in prior calls
fdp(gdp(0.5)) + fdp(lap(1), .legend = "Second")
}
