% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/views.R
\name{view_on_correlation}
\alias{view_on_correlation}
\alias{view_on_correlation.default}
\alias{view_on_correlation.matrix}
\alias{view_on_correlation.xts}
\alias{view_on_correlation.tbl_df}
\title{Views on Correlation Structure}
\usage{
view_on_correlation(x, cor)

\method{view_on_correlation}{default}(x, cor)

\method{view_on_correlation}{matrix}(x, cor)

\method{view_on_correlation}{xts}(x, cor)

\method{view_on_correlation}{tbl_df}(x, cor)
}
\arguments{
\item{x}{An univariate or a multivariate distribution.}

\item{cor}{A \code{matrix} for the target correlation structure of
the series in \code{x}.}
}
\value{
A \code{list} of the \code{view} class.
}
\description{
Helper to construct views  on the correlation matrix.
}
\examples{
library(ggplot2)

# Invariant
ret <- diff(log(EuStockMarkets))

# Assume that a panic event throws all correlations to the roof!
co <- matrix(0.95, 4, 4)
diag(co) <- 1
co

# Prior probability (usually the equal-weight setting)
prior <- rep(1 / nrow(ret), nrow(ret))

# View
views <- view_on_correlation(x = ret, cor = co)
views

# Optimization
ep <- entropy_pooling(p = prior, Aeq = views$Aeq, beq = views$beq, solver = "nlminb")
autoplot(ep)

# prior correlation structure
stats::cor(ret)

# posterior correlation structure matches the initial view very closely
stats::cov2cor(ffp_moments(x = ret, p = ep)$sigma)
}
