% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_generics.R, R/espn_schedule.R,
%   R/flea_schedule.R, R/mfl_schedule.R, R/sleeper_schedule.R
\name{ff_schedule}
\alias{ff_schedule}
\alias{ff_schedule.espn_conn}
\alias{ff_schedule.flea_conn}
\alias{ff_schedule.mfl_conn}
\alias{ff_schedule.sleeper_conn}
\title{Get Schedule}
\usage{
ff_schedule(conn, ...)

\method{ff_schedule}{espn_conn}(conn, ...)

\method{ff_schedule}{flea_conn}(conn, week = 1:17, ...)

\method{ff_schedule}{mfl_conn}(conn, ...)

\method{ff_schedule}{sleeper_conn}(conn, ...)
}
\arguments{
\item{conn}{a conn object created by \code{ff_connect()}}

\item{...}{for other platforms}

\item{week}{a numeric or numeric vector specifying which weeks to pull}
}
\value{
A tidy dataframe with one row per game per franchise per week
}
\description{
This function returns a tidy dataframe with one row for every team for every weekly matchup
}
\section{Methods (by class)}{
\itemize{
\item \code{ff_schedule(espn_conn)}: ESPN: returns schedule data, one row for every franchise for every week. Completed games have result data.

\item \code{ff_schedule(flea_conn)}: Flea: returns schedule data, one row for every franchise for every week. Completed games have result data.

\item \code{ff_schedule(mfl_conn)}: MFL: returns schedule data, one row for every franchise for every week. Completed games have result data.

\item \code{ff_schedule(sleeper_conn)}: Sleeper: returns all schedule data

}}
\examples{
\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  espn_conn <- espn_connect(season = 2020, league_id = 899513)
  ff_schedule(espn_conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  conn <- fleaflicker_connect(season = 2019, league_id = 206154)
  ff_schedule(conn, week = 2:4)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  ssb_conn <- ff_connect(platform = "mfl", league_id = 54040, season = 2020)
  ff_schedule(ssb_conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  jml_conn <- ff_connect(platform = "sleeper", league_id = "522458773317046272", season = 2020)
  ff_schedule(jml_conn)
}) # end try
}

}
