% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_generics.R, R/espn_starters.R,
%   R/flea_starters.R, R/mfl_starters.R, R/sleeper_starters.R
\name{ff_starters}
\alias{ff_starters}
\alias{ff_starters.espn_conn}
\alias{ff_starters.flea_conn}
\alias{ff_starters.mfl_conn}
\alias{ff_starters.sleeper_conn}
\title{Get Starting Lineups}
\usage{
ff_starters(conn, ...)

\method{ff_starters}{espn_conn}(conn, weeks = 1:17, ...)

\method{ff_starters}{flea_conn}(conn, week = 1:17, ...)

\method{ff_starters}{mfl_conn}(conn, week = 1:17, season = NULL, ...)

\method{ff_starters}{sleeper_conn}(conn, week = 1:17, ...)
}
\arguments{
\item{conn}{the list object created by \code{ff_connect()}}

\item{...}{other arguments (currently unused)}

\item{weeks}{which weeks to calculate, a number or numeric vector}

\item{week}{a numeric or one of YTD (year-to-date) or AVG (average to date)}

\item{season}{the season of interest - generally only the most recent 2-3 seasons are available}
}
\value{
A tidy dataframe with every player for every week, including a flag for whether they were started or not
}
\description{
This function returns a tidy dataframe with one row for every starter (and bench) for every week and their scoring, if available.
}
\section{Methods (by class)}{
\itemize{
\item \code{ff_starters(espn_conn)}: ESPN: returns who was started as well as what they scored.

\item \code{ff_starters(flea_conn)}: Fleaflicker: returns who was started as well as what they scored.

\item \code{ff_starters(mfl_conn)}: MFL: returns the player fantasy scores for each week (not the actual stats)

\item \code{ff_starters(sleeper_conn)}: Sleeper: returns only "who" was started, without any scoring/stats data. Only returns season specified in initial connection object.

}}
\examples{
\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  conn <- espn_connect(season = 2020, league_id = 1178049)
  ff_starters(conn, weeks = 1:3)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  conn <- fleaflicker_connect(season = 2020, league_id = 206154)
  ff_starters(conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  dlf_conn <- mfl_connect(2020, league_id = 37920)
  ff_starters(conn = dlf_conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  jml_conn <- sleeper_connect(league_id = "522458773317046272", season = 2020)
  ff_starters(jml_conn, week = 3)
}) # end try
}

}
