% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fire.R
\name{Fire}
\alias{Fire}
\title{Generate a New App Object}
\description{
The Fire generator creates a new \code{Fire}-object, which is the class containing
all the app logic. The class is based on the \link[R6:R6Class]{R6} OO-system and
is thus reference-based with methods and data attached to each object, in
contrast to the more well known S3 and S4 systems. A \code{fiery} server is event
driven, which means that it is build up and manipulated by adding event
handlers and triggering events. To learn more about the \code{fiery} event model,
read the \href{https://fiery.data-imaginist.com/articles/events.html}{event vignette}.
\code{fiery} servers can be modified directly or by attaching plugins. As with
events, \href{https://fiery.data-imaginist.com/articles/plugins.html}{plugins has its own vignette}.
\subsection{Initialization}{

A new 'Fire'-object is initialized using the \code{new()} method on the generator:

\tabular{l}{
\code{app <- Fire$new(host = '127.0.0.1', port = 8080L)}
}
}

\subsection{Copying}{

As \code{Fire} objects are using reference semantics new copies of an app cannot
be made simply be assigning it to a new variable. If a true copy of a \code{Fire}
object is desired, use the \code{clone()} method.
}
}
\examples{
# Create a New App
app <- Fire$new(port = 4689)

# Setup the data every time it starts
app$on('start', function(server, ...) {
    server$set_data('visits', 0)
    server$set_data('cycles', 0)
})

# Count the number of cycles
app$on('cycle-start', function(server, ...) {
    server$set_data('cycles', server$get_data('cycles') + 1)
})

# Count the number of requests
app$on('before-request', function(server, ...) {
    server$set_data('visits', server$get_data('visits') + 1)
})

# Handle requests
app$on('request', function(server, ...) {
    list(
        status = 200L,
        headers = list('Content-Type' = 'text/html'),
        body = paste('This is indeed a test. You are number', server$get_data('visits'))
    )
})

# Show number of requests in the console
app$on('after-request', function(server, ...) {
    message(server$get_data('visits'))
    flush.console()
})

# Terminate the server after 300 cycles
app$on('cycle-end', function(server, ...) {
    if (server$get_data('cycles') > 300) {
        message('Ending...')
        flush.console()
        server$extinguish()
    }
})

# Be polite
app$on('end', function(server) {
    message('Goodbye')
    flush.console()
})

\dontrun{
app$ignite(showcase = TRUE)
}

}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{host}}{A string giving a valid IPv4 address owned by the server, or \code{'0.0.0.0'} to listen on all addresses. The default is \code{'127.0.0.1'}}

\item{\code{port}}{An integer giving the port number the server should listen on (defaults to \code{8080L})}

\item{\code{refresh_rate}}{The interval in seconds between run cycles when running a blocking server (defaults to \code{0.001})}

\item{\code{refresh_rate_nb}}{The interval in seconds between run cycles when running a non-blocking server (defaults to \code{1})}

\item{\code{trigger_dir}}{A valid folder where trigger files can be put when running a blocking server (defaults to \code{NULL}). See the \href{https://fiery.data-imaginist.com/articles/events.html}{\emph{The event cycle in fiery} vignette} for more information.}

\item{\code{plugins}}{A named list of the already attached plugins. \strong{Read Only} - can only be modified using the \code{attach()} method.}

\item{\code{data_store}}{Access the environment that holds the global data store}

\item{\code{root}}{The location of the app. Setting this will remove the root value from requests (or decline them with \code{400} if the request does not match the root). E.g. the path of a request will be changed from \verb{/demo/test} to \verb{/test} if \code{root == '/demo'}}

\item{\code{access_log_format}}{A \link[glue:glue]{glue} string defining how requests will be logged. For standard formats see \link{common_log_format} and \link{combined_log_format}. Defaults to the \emph{Common Log Format}}

\item{\code{key}}{The encryption key to use for request/response encryption}

\item{\code{session_cookie_settings}}{Get or set the session cookie settings}

\item{\code{trust}}{A logical indicating whether incoming requests are trusted.}

\item{\code{compression_limit}}{The size threshold in bytes for trying to
compress the response body (it is still dependant on content negotiation)}

\item{\code{query_delim}}{The delimeter used to split array-type query arguments
when parsing the query string}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Fire-new}{\code{Fire$new()}}
\item \href{#method-Fire-format}{\code{Fire$format()}}
\item \href{#method-Fire-ignite}{\code{Fire$ignite()}}
\item \href{#method-Fire-start}{\code{Fire$start()}}
\item \href{#method-Fire-reignite}{\code{Fire$reignite()}}
\item \href{#method-Fire-resume}{\code{Fire$resume()}}
\item \href{#method-Fire-extinguish}{\code{Fire$extinguish()}}
\item \href{#method-Fire-stop}{\code{Fire$stop()}}
\item \href{#method-Fire-on}{\code{Fire$on()}}
\item \href{#method-Fire-off}{\code{Fire$off()}}
\item \href{#method-Fire-trigger}{\code{Fire$trigger()}}
\item \href{#method-Fire-send}{\code{Fire$send()}}
\item \href{#method-Fire-close_ws_con}{\code{Fire$close_ws_con()}}
\item \href{#method-Fire-serve_static}{\code{Fire$serve_static()}}
\item \href{#method-Fire-exclude_static}{\code{Fire$exclude_static()}}
\item \href{#method-Fire-attach}{\code{Fire$attach()}}
\item \href{#method-Fire-has_plugin}{\code{Fire$has_plugin()}}
\item \href{#method-Fire-header}{\code{Fire$header()}}
\item \href{#method-Fire-set_data}{\code{Fire$set_data()}}
\item \href{#method-Fire-get_data}{\code{Fire$get_data()}}
\item \href{#method-Fire-remove_data}{\code{Fire$remove_data()}}
\item \href{#method-Fire-time}{\code{Fire$time()}}
\item \href{#method-Fire-remove_time}{\code{Fire$remove_time()}}
\item \href{#method-Fire-delay}{\code{Fire$delay()}}
\item \href{#method-Fire-remove_delay}{\code{Fire$remove_delay()}}
\item \href{#method-Fire-async}{\code{Fire$async()}}
\item \href{#method-Fire-remove_async}{\code{Fire$remove_async()}}
\item \href{#method-Fire-set_client_id_converter}{\code{Fire$set_client_id_converter()}}
\item \href{#method-Fire-set_logger}{\code{Fire$set_logger()}}
\item \href{#method-Fire-log}{\code{Fire$log()}}
\item \href{#method-Fire-is_running}{\code{Fire$is_running()}}
\item \href{#method-Fire-safe_call}{\code{Fire$safe_call()}}
\item \href{#method-Fire-test_request}{\code{Fire$test_request()}}
\item \href{#method-Fire-test_header}{\code{Fire$test_header()}}
\item \href{#method-Fire-test_message}{\code{Fire$test_message()}}
\item \href{#method-Fire-test_websocket}{\code{Fire$test_websocket()}}
\item \href{#method-Fire-clone}{\code{Fire$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-new"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Fire} app
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$new(host = "127.0.0.1", port = 8080)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{A string overriding the default host}

\item{\code{port}}{An port number overriding the default port}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Fire} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-format"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-format}{}}}
\subsection{Method \code{format()}}{
Human readable description of the app
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$format(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-ignite"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-ignite}{}}}
\subsection{Method \code{ignite()}}{
Begin running the server. Will trigger the \code{start} event
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$ignite(block = TRUE, showcase = FALSE, ..., silent = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{block}}{Should the console be blocked while running (alternative is to run in the background)}

\item{\code{showcase}}{Should the default browser open up at the server address.
If \code{TRUE} then a browser opens at the root of the app. If a string the
string is used as a path to add to the root before opening}

\item{\code{...}}{Arguments passed on to the \code{start} handler}

\item{\code{silent}}{Should startup messaging by silenced}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-start"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-start}{}}}
\subsection{Method \code{start()}}{
Synonymous method to \code{ignite()}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$start(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{passed on to \code{ignite()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-reignite"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-reignite}{}}}
\subsection{Method \code{reignite()}}{
Resume a session. This is equivalent to \code{ignite()} but will also trigger the \code{resume} event
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$reignite(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{passed on to \code{ignite()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-resume"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-resume}{}}}
\subsection{Method \code{resume()}}{
Synonymous method to \code{reignite()}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$resume(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{passed on to \code{ignite()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-extinguish"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-extinguish}{}}}
\subsection{Method \code{extinguish()}}{
Stop the server. Will trigger the \code{end} event
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$extinguish()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-stop"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-stop}{}}}
\subsection{Method \code{stop()}}{
Synonymous method to \code{extinguish()}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$stop()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-on"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-on}{}}}
\subsection{Method \code{on()}}{
Add a handler to an event. See the \href{https://fiery.data-imaginist.com/articles/events.html}{\emph{The event cycle in fiery} vignette} for more information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$on(event, handler, pos = NULL, id = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{event}}{The name of the event that should trigger the handler}

\item{\code{handler}}{The handler function that should be triggered}

\item{\code{pos}}{The position in the handler stack to place it at. \code{NULL} will place it at the end.}

\item{\code{id}}{An optional id to use to identify the handler}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A unique string identifying the handler (either \code{id} or generated for you)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-off"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-off}{}}}
\subsection{Method \code{off()}}{
Remove an event handler from the app.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$off(handlerId)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handlerId}}{The unique id identifying the handler}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-trigger"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-trigger}{}}}
\subsection{Method \code{trigger()}}{
Trigger an event in the app. This will cause any handler attached to the event to be called. See the \href{https://fiery.data-imaginist.com/articles/events.html}{\emph{The event cycle in fiery} vignette} for more information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$trigger(event, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{event}}{The name of the event}

\item{\code{...}}{Arguments passed on to the handlers}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A named list containing the return values of all handlers attached to the event
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-send"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-send}{}}}
\subsection{Method \code{send()}}{
Send a Websocket message to a client. Will trigger the \code{send} event.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$send(message, id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{message}}{The message to send}

\item{\code{id}}{The id of the client to send to. If missing, the message will be send to all clients}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-close_ws_con"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-close_ws_con}{}}}
\subsection{Method \code{close_ws_con()}}{
Close a Websocket connection. Will trigger the \code{websocket-closed} event
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$close_ws_con(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The id of the client to close the websocket connection to}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-serve_static"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-serve_static}{}}}
\subsection{Method \code{serve_static()}}{
Serve a file or directory of files at a specified url path. Requests matching a file on the system never enters into the request loop but are served directly (and fast). Due to this, logging for these requests are also turned off
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$serve_static(
  at,
  path,
  use_index = TRUE,
  fallthrough = FALSE,
  html_charset = "utf-8",
  headers = list(),
  validation = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{at}}{The url path to listen to requests on}

\item{\code{path}}{The path to the file or directory on the file system}

\item{\code{use_index}}{Should an \code{index.html} file be served if present when a client requests the folder}

\item{\code{fallthrough}}{Should requests that doesn't match a file enter the request loop or have a 404 response send directly}

\item{\code{html_charset}}{The charset to report for serving html files}

\item{\code{headers}}{A list of headers to add to the response. Will be combined with the global headers of the app}

\item{\code{validation}}{An optional validation pattern. Presently, the only type of validation supported is an exact string match of a header. For example, if validation is \code{"abc" = "xyz"}, then HTTP requests must have a header named \code{abc} (case-insensitive) with the value \code{"xyz"} (case-sensitive). If a request does not have a matching header, than httpuv will give a 403 Forbidden response. If \code{character(0)} (the default), then no validation check will be performed.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-exclude_static"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-exclude_static}{}}}
\subsection{Method \code{exclude_static()}}{
Exclude a url path from serving static content. Only meaningful to exclude sub paths of path that are set to serve static content
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$exclude_static(at)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{at}}{The url path to exclude from static serving. Request to this path will enter the normal request loop}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-attach"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-attach}{}}}
\subsection{Method \code{attach()}}{
Attach a plugin to the app. See the \href{https://fiery.data-imaginist.com/articles/plugins.html}{\emph{Creating and using fiery plugins} vignette} for more information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$attach(plugin, ..., name = NULL, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plugin}}{The plugin to attach}

\item{\code{...}}{Arguments to pass into the plugins \code{on_attach()} method}

\item{\code{name}}{Optional name for the plugin. If omitted \code{plugin$name} will be used instead}

\item{\code{force}}{If the plugin has already been attached an error is thrown, unless \code{force = TRUE} which tells the app to reattach it}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-has_plugin"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-has_plugin}{}}}
\subsection{Method \code{has_plugin()}}{
Check if the app has a plugin attached
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$has_plugin(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the plugin}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A boolean indicating if the given plugin is already attached
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-header"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-header}{}}}
\subsection{Method \code{header()}}{
Add a global http header that will be applied to all responses
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$header(name, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the header}

\item{\code{value}}{The value of the header. Use \code{NULL} to remove the global header}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-set_data"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-set_data}{}}}
\subsection{Method \code{set_data()}}{
Add data to the global data store
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$set_data(name, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name identifying the data}

\item{\code{value}}{The data to add}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-get_data"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-get_data}{}}}
\subsection{Method \code{get_data()}}{
Retrieve data from the global data store
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$get_data(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name identifying the data}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The data requested. Returns \code{NULL} if the store does not contain the requested data
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-remove_data"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-remove_data}{}}}
\subsection{Method \code{remove_data()}}{
Remove data from the global data store
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$remove_data(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name identifying the data to be removed}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-time"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-time}{}}}
\subsection{Method \code{time()}}{
Add a timed evaluation that will be evaluated after the given number of seconds.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$time(expr, then, after, loop = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expr}}{The expression to evaluate when the time has passed}

\item{\code{then}}{A handler to call once \code{expr} has been evaluated}

\item{\code{after}}{The time in second to wait before evaluating \code{expr}}

\item{\code{loop}}{Should \code{expr} be called repeatedly with the interval given by \code{after}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A unique id identifying the handler
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-remove_time"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-remove_time}{}}}
\subsection{Method \code{remove_time()}}{
Remove a timed evaluation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$remove_time(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The unique id identifying the handler}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-delay"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-delay}{}}}
\subsection{Method \code{delay()}}{
Add a delayed evaluation to be evaluated immediately at the end of the loop cycle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$delay(expr, then)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expr}}{The expression to evaluate at the end of the cycle}

\item{\code{then}}{A handler to call once \code{expr} has been evaluated}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A unique id identifying the handler
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-remove_delay"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-remove_delay}{}}}
\subsection{Method \code{remove_delay()}}{
Remove a delayed evaluation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$remove_delay(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The unique id identifying the handler}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-async"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-async}{}}}
\subsection{Method \code{async()}}{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Add an asynchronous evaluation to be evaluated in another process without blocking the server. This function has been deprecated in favor of using your own async framework of choice, e.g. \href{https://mirai.r-lib.org}{mirai} or \href{https://rstudio.github.io/promises/}{promises}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$async(expr, then)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expr}}{The expression to evaluate at the end of the cycle}

\item{\code{then}}{A handler to call once \code{expr} has been evaluated}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A unique id identifying the handler
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-remove_async"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-remove_async}{}}}
\subsection{Method \code{remove_async()}}{
Remove an async evaluation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$remove_async(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The unique id identifying the handler}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-set_client_id_converter"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-set_client_id_converter}{}}}
\subsection{Method \code{set_client_id_converter()}}{
Sets the function that converts an HTTP request into a specific client id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$set_client_id_converter(converter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{converter}}{A function with the argument \code{request}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-set_logger"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-set_logger}{}}}
\subsection{Method \code{set_logger()}}{
Sets the logging function to use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$set_logger(logger)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{logger}}{A function with the arguments \code{event}, \code{message}, \code{request}, and \code{...}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-log"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-log}{}}}
\subsection{Method \code{log()}}{
Log a message with the logger attached to the app. See \link{loggers} for build in functionality
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$log(
  event,
  message,
  request = NULL,
  ...,
  .logcall = sys.call(),
  .topcall = sys.call(-1),
  .topenv = parent.frame()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{event}}{The event associated with the message}

\item{\code{message}}{The message to log}

\item{\code{request}}{The \code{Request} object associated with the message, if any.}

\item{\code{...}}{Additional arguments passed on to the logger.}

\item{\code{.logcall}}{The call that send the log request}

\item{\code{.topcall}}{The call in which \code{.logcall} is called from}

\item{\code{.topenv}}{The environment associated with \code{.topcall}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-is_running"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-is_running}{}}}
\subsection{Method \code{is_running()}}{
Test if an app is running
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$is_running()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-safe_call"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-safe_call}{}}}
\subsection{Method \code{safe_call()}}{
Evaluate an expression safely, logging any errors, warnings,
or messages that bubbles up
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$safe_call(expr, request = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expr}}{An expression to evaluate}

\item{\code{request}}{The request under evaluation, if any. Used in logging}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The value of the expression. If an error is caught, the condition
object is returned instead
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-test_request"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-test_request}{}}}
\subsection{Method \code{test_request()}}{
Send a request directly to the request logic of a non-running app. Only intended for testing the request logic
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$test_request(request)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{The request to send}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-test_header"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-test_header}{}}}
\subsection{Method \code{test_header()}}{
Send a request directly to the header logic of a non-running app. Only intended for testing the request logic
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$test_header(request)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{The request to send}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-test_message"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-test_message}{}}}
\subsection{Method \code{test_message()}}{
Send a message directly \strong{to} the message logic of a non-running app. Only intended for testing the websocket logic
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$test_message(request, binary, message, withClose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{The request to use to establish the connection}

\item{\code{binary}}{Is the message send in binary or character format}

\item{\code{message}}{The message to send. If \code{binary = FALSE} a character vector, if \code{binary = TRUE} a raw vector}

\item{\code{withClose}}{Should the websocket connection be closed at the end by the client}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-test_websocket"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-test_websocket}{}}}
\subsection{Method \code{test_websocket()}}{
Send a message directly \strong{from} a non-running app. Only intended for testing the websocket logic
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$test_websocket(request, message, close = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{The request to use to establish the connection}

\item{\code{message}}{The message to send from the app}

\item{\code{close}}{Should the websocket connection be closed at the end by the server}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Fire-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Fire-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
