% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findGSE_v1.95_new.R
\name{findGSE_raw}
\alias{findGSE_raw}
\title{Estimate Genome Size Using Raw K-mer Frequencies}
\usage{
findGSE_raw(histo = "", sizek = 0, outdir = "", exp_hom = 0, species = "")
}
\arguments{
\item{histo}{A character string specifying the path to the histogram file.}

\item{sizek}{An integer indicating the size of k used to generate the histogram.}

\item{outdir}{A character string specifying the output directory. If not specify, will use tempdir() as output directory.}

\item{exp_hom}{A numeric value representing the expected average k-mer coverage for the homozygous regions.}

\item{species}{A character string specifying the species name.}
}
\value{
A list containing the estimated genome size and other fitting parameters.
}
\description{
This function estimates the genome size of a species using raw k-mer frequencies.
}
\examples{
\dontrun{

histo <- "sample1.histo"
sizek <- 21
outdir <- tempdir()
exp_hom <- 200
species <- ""
fit_lists <- findGSE_raw(histo, sizek,output_dir, exp_hom, species)
}
}
