% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{border_id_trans_cap_FI_EE_RTD}
\alias{border_id_trans_cap_FI_EE_RTD}
\title{Intraday transmission capacity FI-EE - real time data}
\usage{
border_id_trans_cap_FI_EE_RTD(
  start_time_utc = NA,
  end_time_utc = NA,
  user_key = NA
)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 1 h and unit type MW.
}
\description{
Transmission capacity to be given to intraday market FI-EE.After Elspot trades have been closed, real time intraday capacity is equivalent to the allocated intraday capacity. The real time capacity is updated after each intraday trade so that it corresponds to real time situation.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- border_id_trans_cap_FI_EE_RTD(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/114
}
