% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{imbalance_consumption_price}
\alias{imbalance_consumption_price}
\title{The price of comsumption imbalance electricity}
\usage{
imbalance_consumption_price(
  start_time_utc = NA,
  end_time_utc = NA,
  user_key = NA
)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 1 h and unit type EUR/MWh.
}
\description{
The price of consumption imbalance power is the price for which Fingrid both purchases imbalance power from a balance responsible party and sells it to one. In the case of regulating hour, the regulation price is used. If no regulation has been made, the Elspot FIN price is used as the purchase and selling price of consumption imbalance power. Data gathering to Excel-sheet or XML format is possible in periods not longer that one year due to limitations in data transmission. Separate consumption imbalance ended when 1.11.2021 01.00 settlement model was changed to single imbalance.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- imbalance_consumption_price(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/92
}
