% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01b_prepare_svydesign.R
\name{fst_format_svydesign}
\alias{fst_format_svydesign}
\title{Annotate open-ended survey responses within a `svydesign` object
into CoNLL-U format}
\usage{
fst_format_svydesign(
  svydesign,
  question,
  id,
  model = "ftb",
  use_weights = TRUE,
  add_cols = NULL
)
}
\arguments{
\item{svydesign}{A `svydesign` object which contains an open-ended question.}

\item{question}{The column in the dataframe which contains the open-ended
question.}

\item{id}{The column in the dataframe which contains the ids for the
responses.}

\item{model}{A language model available for [udpipe]. `"ftb"`
(default) or `"tdt"` are recognised as shorthand for "finnish-ftb" and
"finnish-tdt". The full list is available in the [udpipe] documentation or
via `fst_print_available_models()`.}

\item{use_weights}{Optional, whether to use weights within the `svydesign`}

\item{add_cols}{Optional, a column (or columns) from the dataframe which
contain other information you'd like to retain (for instance, dimension
columnns for splitting the data for comparison plots).}
}
\value{
Dataframe of annotated text in CoNLL-U format plus any additional
 columns.
}
\description{
Creates a dataframe in CoNLL-U format from a `svydesign` object including
text using the [udpipe] package and a language model plus
weights if these are included in the `svydesign` object and any columns added
through `add_cols`.
}
\examples{
\dontrun{
i <- "fsd_id"
svy_child <- survey::svydesign(id=~1, weights= ~paino, data = child)
fst_format_svydesign(svy_child, question = 'q7', id = 'fsd_id')
fst_format_svydesign(svy_child, question = 'q7', id = i, use_weights = FALSE)
cols <- c('gender', 'major_region')
fst_format_svydesign(svy_child, 'q7', 'fsd_id', add_cols = cols)

svy_dev <- survey::svydesign(id = ~1, weights = ~paino, data = dev_coop)
fst_format_svydesign(svy_dev, 'q11_1', 'fsd_id', add_cols = 'gender, region')

fst_format_svydesign(svy_dev, 'q11_2', 'fsd_id', 'finnish-ftb')
unlink("finnish-ftb-ud-2.5-191206.udpipe")
unlink("finnish-tdt-ud-2.5-191206.udpipe")
}
}
