% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_comparison_functions.R
\name{fst_join_unique}
\alias{fst_join_unique}
\title{Merge N-grams table with unique words}
\usage{
fst_join_unique(table, unique_table)
}
\arguments{
\item{table}{Output of `fst_freq_table()` or `fst_ngrams_table()`.}

\item{unique_table}{Output of `fst_get_unique_ngrams()`.}
}
\value{
A table of top n-grams, frequency, and whether the n-gram is
 "unique".
}
\description{
Merges list of unique words from `fst_get_unique_ngrams()` with output of
`fst_freq_table()` or `fst_ngrams_table()` so that unique words can be
displayed on comparison plots.
}
\examples{
top_child <- fst_freq_table(fst_child)
top_dev <- fst_freq_table(fst_dev_coop)
unique_words <- fst_get_unique_ngrams_separate(top_child, top_dev)
fst_join_unique(top_child, unique_words)
fst_join_unique(top_dev, unique_words)
}
