% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Triangle.R
\name{NegLLTriBin}
\alias{NegLLTriBin}
\title{Negative Log Likelihood value of Triangular Binomial Distribution}
\usage{
NegLLTriBin(x,freq,mode)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{freq}{vector of frequencies.}

\item{mode}{single value for mode.}
}
\value{
The output of \code{NegLLTriBin} will produce a single numeric value.
}
\description{
This function will calculate the Negative Log Likelihood value when the vector of binomial random
variables and vector of corresponding frequencies are given with the mode value.
}
\details{
\deqn{0 < mode=c < 1}
\deqn{x = 0,1,2,,...}
\deqn{freq \ge 0}

\strong{NOTE} : If input parameters are not in given domain conditions necessary error
 messages will be provided to go further.
}
\examples{
No.D.D <- 0:7    #assigning the Random variables
Obs.fre.1 <- c(47,54,43,40,40,41,39,95) #assigning the corresponding frequencies

NegLLTriBin(No.D.D,Obs.fre.1,.023)   #acquiring the Negative log likelihood value

}
\references{
\insertRef{horsnell1957economical}{fitODBOD}
\insertRef{karlis2008polygonal}{fitODBOD}
\insertRef{okagbue2014using}{fitODBOD}
}
