% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmix.R
\name{dmix}
\alias{dmix}
\title{The mixture distribution}
\usage{
dmix(lifespan, model, K, param)
}
\arguments{
\item{lifespan}{Vector of samples}

\item{model}{choice of one of the mixture models; \code{gompertz}, \code{log-logistics}, \code{log-normal}, and \code{weibull}.}

\item{K}{number of components}

\item{param}{Vector of weight \eqn{\omega}, shape \eqn{\alpha}, and scale \eqn{\beta} parameters.}
}
\value{
A vector of the same length as lifespan data, given the pdf of the one of the mixture models computed at \code{lifespan}.
}
\description{
Computing probability density function for the well-known mixture models.
}
\examples{
lifespan<-seq(0,30,0.2)
K<-2
weight<-c(0.6,0.4)
alpha<-c(0.5,1)
beta<-c(1,0.5)
param<-c(weight,alpha,beta)
dmix(lifespan, "log-logistic", K, param)
}
