% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitLandDF.R
\name{FitLandDF}
\alias{FitLandDF}
\title{Create New FitLandDF Instance}
\usage{
FitLandDF(scape_data, dims = dim(scape_data))
}
\arguments{
\item{scape_data}{either data.frame or array object}

\item{dims}{integer vector containing dimensions}
}
\value{
FitLandDF object
}
\description{
Create New FitLandDF Instance
}
\examples{
# create a flat fitness landscape with 3 binary (values 1 and 2) dimensions
values <- array(2, dim = rep(2, 3))

my_landscape <- FitLandDF(values)

# create a 2x2 fitness landscape that's highest when both dimensions are at 1
vals <- 1:2
df <- expand.grid(vals, vals)
df$Landscape_value <- c(1, 2, 3, 6)

my_landscape <- FitLandDF(df, dims = c(2L, 2L))
}
