#' FLaMingos: Functional Latent datA Models for clusterING heterogeneOus curveS
#'
#' @description `flamingos` is an open-source toolbox for the simultaneous
#' clustering (or classification) and segmentation of heterogeneous functional
#' data (i.e time-series ore more generally longitudinal data), with original
#' and flexible functional latent variable models, fitted by unsupervised
#' algorithms, including EM algorithms.
#'
#' `flamingos` contains the following time series clustering and segmentation models:
#'
#' \itemize{
#' \item mixRHLP;
#' \item mixHMM;
#' \item mixHMMR.
#' }
#'
#' For the advantages/differences of each of them, the user is referred to our
#' mentioned paper references.
#'
#' To learn more about `flamingos`, start with the vignettes:
#' `browseVignettes(package = "flamingos")`
#'
#' @references
#'
#' Chamroukhi, Faicel, and Hien D. Nguyen. 2019. \emph{Model-Based Clustering and Classification of Functional Data.} Wiley Interdisciplinary Reviews: Data Mining and Knowledge Discovery. \url{https://chamroukhi.com/papers/MBCC-FDA.pdf}.
#'
#' Chamroukhi, F. 2016. \emph{Unsupervised Learning of Regression Mixture Models with Unknown Number of Components.} Journal of Statistical Computation and Simulation 86 (November): 2308--34. \url{https://chamroukhi.com/papers/Chamroukhi-JSCS-2015.pdf}.
#'
#' Chamroukhi, Faicel. 2016. \emph{Piecewise Regression Mixture for Simultaneous Functional Data Clustering and Optimal Segmentation.} Journal of Classification 33 (3): 374--411. \url{https://chamroukhi.com/papers/Chamroukhi-PWRM-JournalClassif-2016.pdf}.
#'
#' Chamroukhi, F. 2015. \emph{Statistical Learning of Latent Data Models for Complex Data Analysis.} Habilitation Thesis (HDR), Universite de Toulon. \url{https://chamroukhi.com/Dossier/FChamroukhi-Habilitation.pdf}.
#'
#' Chamroukhi, F., H. Glotin, and A. Same. 2013. \emph{Model-Based Functional Mixture Discriminant Analysis with Hidden Process Regression for Curve Classification.} Neurocomputing 112: 153--63. \url{https://chamroukhi.com/papers/chamroukhi_et_al_neucomp2013a.pdf}.
#'
#' Chamroukhi, F., and H. Glotin. 2012. \emph{Mixture Model-Based Functional Discriminant Analysis for Curve Classification.} In Proceedings of the International Joint Conference on Neural Networks (IJCNN), IEEE, 1--8. Brisbane, Australia. \url{https://chamroukhi.com/papers/Chamroukhi-ijcnn-2012.pdf}.
#'
#' Same, A., F. Chamroukhi, Gerard Govaert, and P. Aknin. 2011. \emph{Model-Based Clustering and Segmentation of Time Series with Changes in Regime.} Advances in Data Analysis and Classification 5 (4): 301--21. \url{https://chamroukhi.com/papers/adac-2011.pdf}.
#'
#' Chamroukhi, F., A. Same, P. Aknin, and G. Govaert. 2011. \emph{Model-Based Clustering with Hidden Markov Model Regression for Time Series with Regime Changes.} In Proceedings of the International Joint Conference on Neural Networks (IJCNN), IEEE, 2814--21. \url{https://chamroukhi.com/papers/Chamroukhi-ijcnn-2011.pdf}.
#'
#' Chamroukhi, F., A. Same, G. Govaert, and P. Aknin. 2010. \emph{A Hidden Process Regression Model for Functional Data Description. Application to Curve Discrimination.} Neurocomputing 73 (7-9): 1210--21. \url{https://chamroukhi.com/papers/chamroukhi_neucomp_2010.pdf}.
#'
#' Chamroukhi, F. 2010. \emph{Hidden Process Regression for Curve Modeling, Classification and Tracking.} Ph.D. Thesis, Universite de Technologie de Compiegne. \url{https://chamroukhi.com/papers/FChamroukhi-Thesis.pdf}.
#'
#' @import methods
## usethis namespace: start
#' @useDynLib flamingos, .registration = TRUE
## usethis namespace: end
## usethis namespace: start
#' @importFrom Rcpp sourceCpp
## usethis namespace: end
"_PACKAGE"
