% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sspFunctions.R, R/zzz_aliases.R
\name{fitSSP_fixed}
\alias{fitSSP_fixed}
\alias{fit_ssp_fixed}
\title{Fit the SSP model to human data with some fixed parameters}
\usage{
fitSSP_fixed(
  data,
  conditionName = NULL,
  parms = c(0.05, 0.3, 0.4, 0.05, 1.5),
  cdfs = c(0.1, 0.3, 0.5, 0.7, 0.9),
  cafs = c(0.25, 0.5, 0.75),
  maxParms = c(1, 1, 1, 1, 2),
  nTrials = 50000,
  multipleSubjects = TRUE,
  fixed = c(FALSE, FALSE, FALSE, FALSE, FALSE),
  seed = NULL
)

fit_ssp_fixed(
  data,
  conditionName = NULL,
  parms = c(0.05, 0.3, 0.4, 0.05, 1.5),
  cdfs = c(0.1, 0.3, 0.5, 0.7, 0.9),
  cafs = c(0.25, 0.5, 0.75),
  maxParms = c(1, 1, 1, 1, 2),
  nTrials = 50000,
  multipleSubjects = TRUE,
  fixed = c(FALSE, FALSE, FALSE, FALSE, FALSE),
  seed = NULL
)
}
\arguments{
\item{data}{A data frame containing human data. See \code{?exampleData} for
data formatted correctly.}

\item{conditionName}{If there is an additional experimental manipulation
(i.e., other than target congruency) the model can only be fit to one at a
time. Tell the function which condition is currently being fit by passing
a string to the function (e.g., "present"). The function by default assumes
no additional condition (e.g., conditionName is set to NULL).}

\item{parms}{A vector of starting parameters to use in the minimisation
routine. Must be in the order: \code{A}, \code{ter}, \code{p}, \code{rd},
\code{sda}.}

\item{cdfs}{A vector of quantile values for cumulative distribution functions
to be estimated from the human data. The model will attempt to find the
best-fitting parameters that match this distributional data.}

\item{cafs}{A vector of quantiles for conditional accuracy functions to be
estimated from the human data. The model will attempt to find the best-
fitting parameters that match this distributional data.}

\item{maxParms}{A vector containing upper limits on possible parameter
values.}

\item{nTrials}{An integer stating how many trials to simulate per iteration
of the fitting cycle for each congruency type.}

\item{multipleSubjects}{A boolean stating whether the fit is to multiple
subjects (multipleSubjects = TRUE) or to a single subject
(multipleSubjects = FALSE).}

\item{fixed}{A vector of TRUE/FALSE stating whether each parameter should be
fixed (TRUE) or free (FALSE) during the fitting routine. Must be in the
order: \code{A}, \code{ter}, \code{p}, \code{rd}, \code{sda}.}

\item{seed}{The value for the \code{set.seed} function to set random
generation state.}
}
\value{
\code{bestParameters} A vector of the best-fitting parameters found
by the current fit run.

\code{g2} The value of Wilks likelihood ratio (G2) obtained by the
current fit run.

\code{bBIC} The value of the  Bayesian Information Criterion (BIC)
obtained by the current fit run. This is calculated using the BIC equation
for binned data, hence bBIC (binned BIC).
}
\description{
\code{fitSSP_fixed} fits the SSP model to a single experimental condition of
human data (besides congruency, which it accounts for simutaneously). This
function allows the user to fix some parameters (using the \code{fixed}
variable).
}
\details{
This function can be employed by the user to find the best-fitting
parameters of the SSP model to fit the human data of a single experimental
condition. The fitting procedure accounts for congruent and incongruent
trials simultaneously. The fit is obtained by a gradient-descent method
(using the Nelder-Mead method contained in R's \code{optim} function) and is
fit to the proportion of data contained in human CDF and CAF distributional
data.
}
\examples{
# Load the example data the comes with the \code{flankr} package
data(exampleData)
# Fix the first parameter (A) during the fit.
parms = c(0.050, 0.300, 0.400, 0.050, 1.500)
fixed <- c(TRUE, FALSE, FALSE, FALSE, FALSE)

# fit the model
# (Note this is a toy example with very low trial numbers to speed up the
# example. For proper use, increase nTrials.)
\donttest{
fit <- fitSSP_fixed(exampleData, conditionName = "present", parms = parms,
                    fixed = fixed, nTrials = 100)
}

}
