% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL_stabs_fitfun.R
\name{SL_stabs_fitfun}
\alias{SL_stabs_fitfun}
\title{Wrapper for using Super Learner-based extrinsic selection within stability selection}
\usage{
SL_stabs_fitfun(x, y, q, ...)
}
\arguments{
\item{x}{the features.}

\item{y}{the outcome of interest.}

\item{q}{the number of features to select on average.}

\item{...}{other arguments to pass to \code{SuperLearner}.}
}
\value{
a named list, with elements: \code{selected} (a logical vector
indicating whether or not each variable was selected); and \code{path} (
a logical matrix indicating which variable was selected at each step).
}
\description{
A wrapper function for Super Learner-based extrinsic variable selection within
stability selection, using the \code{stabs} package.
}
\examples{
\donttest{
data("biomarkers")
# subset to complete cases for illustration
cc <- complete.cases(biomarkers)
dat_cc <- biomarkers[cc, ]
# use only the mucinous outcome, not the high-malignancy outcome
y <- dat_cc$mucinous
x <- dat_cc[, !(names(dat_cc) \%in\% c("mucinous", "high_malignancy"))]
feature_nms <- names(x)
# use stability selection with SL (using small number of folds for CV, 
# small SL library and small number of bootstrap replicates for illustration only)
set.seed(20231129)
library("SuperLearner")
sl_stabs <- stabs::stabsel(x = x, y = y,
                           fitfun = SL_stabs_fitfun,
                           args.fitfun = list(SL.library = "SL.glm", cvControl = list(V = 2)),
                           q = 2, B = 5, PFER = 5)
sl_stabs
}
}
\seealso{
\code{\link[stabs]{stabsel}} for general usage of stability selection.
}
