% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spvim_vcov.R
\name{spvim_vcov}
\alias{spvim_vcov}
\title{Extract a Variance-Covariance Matrix for SPVIM Estimates}
\usage{
spvim_vcov(spvim_ests = NULL)
}
\arguments{
\item{spvim_ests}{estimated SPVIMs}
}
\value{
a variance-covariance matrix
}
\description{
Extract a variance-covariance matrix based on the efficient influence function
for each of the estimated SPVIMs.
}
\examples{
\donttest{
data("biomarkers")
# subset to complete cases for illustration
cc <- complete.cases(biomarkers)
dat_cc <- biomarkers[cc, ]
# use only the mucinous outcome, not the high-malignancy outcome
y <- dat_cc$mucinous
x <- dat_cc[, !(names(dat_cc) \%in\% c("mucinous", "high_malignancy"))]
feature_nms <- names(x)
# estimate SPVIMs (using simple library and V = 2 for illustration only)
set.seed(20231129)
library("SuperLearner")
est <- vimp::sp_vim(Y = y, X = x, V = 2, type = "auc", SL.library = "SL.glm", 
                    cvControl = list(V = 2))
# get variance-covariance matrix
vcov <- spvim_vcov(spvim_ests = est)
}
}
